/*
 * This file is part of the DXX-Rebirth project <https://www.dxx-rebirth.com/>.
 * It is copyright by its individual contributors, as recorded in the
 * project's Git history.  See COPYING.txt at the top level for license
 * terms and a link to the Git history.
 */

#define DXX_SCONF_NO_INCLUDES
#include "dxxsconf.h"

/* These macros are present in the input text to pass information to the
 * Python script `similar/main/generate-kconfig-udlr.py`.  Their content
 * is made available to the compiler in generated definitions, rather
 * than by exposing them in their original location in the source file.
 * Instruct the preprocessor to remove them when performing a regular
 * compile of the table. */
#ifndef DXX_KCONFIG_UI_ENUM
#define DXX_KCONFIG_UI_ENUM(ENUM)
#endif

#ifndef DXX_KCONFIG_UI_LABEL
#define DXX_KCONFIG_UI_LABEL(LABEL)
#endif

#define DXX_KCONFIG_UI_UDLR3(A,B)	DXX_KCONFIG_UI_UDLR_A_ ## A ## _B_ ## B()
#define DXX_KCONFIG_UI_UDLR2(A,B)	DXX_KCONFIG_UI_UDLR3(A,B)
#define DXX_KCONFIG_UI_UDLR()	DXX_KCONFIG_UI_UDLR2(0,__LINE__)
#define DXX_KCONFIG_UI_LABEL_BLANK	""
#define DXX_KCONFIG_UI_INVERT_FLAG_WIDTH	8
#define DXX_KCONFIG_UI_ROW_CELL_HEIGHT(N)	(8 * N)
#define DXX_KCONFIG_UI_ROW_SEPARATOR_HEIGHT	4
#define DXX_KCONFIG_UI_CELL_WIDTH	26

#define DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y	49
#define DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y	DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_SEPARATOR_HEIGHT
#define DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y	DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_SEPARATOR_HEIGHT
#define DXX_KCONFIG_UI_KEYBOARD_X1_GROUP4_Y	DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y + 8
#define DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y	DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y
#define DXX_KCONFIG_UI_KEYBOARD_X2_GROUP2_Y	DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_SEPARATOR_HEIGHT
#define DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y	DXX_KCONFIG_UI_KEYBOARD_X2_GROUP2_Y + DXX_KCONFIG_UI_ROW_SEPARATOR_HEIGHT
#define DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y	DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y + DXX_KCONFIG_UI_ROW_SEPARATOR_HEIGHT
#define DXX_KCONFIG_UI_KEYBOARD_X2_GROUP5_Y	DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + 6

#define DXX_KCONFIG_UI_KEYBOARD_LABEL_X1	15
#define DXX_KCONFIG_UI_KEYBOARD_LABEL_X2	158
#define DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1	86
#define DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2	115
#define DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1	241
#define DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2	270

#ifdef kc_item
//	  x,  y, xi, w2,  u,  d,   l, r, type, state_bit, state_ptr
constexpr kc_item kc_keyboard[] = {
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Pitch forward") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_pitch_forward} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_pitch_forward} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Pitch backward") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_pitch_backward} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_pitch_backward} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Turn left") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_heading_left} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_heading_left} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Turn right") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_heading_right} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_heading_right} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide on") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::slide_on} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::slide_on} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide left") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_slide_left} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_slide_left} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide right") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_slide_right} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_slide_right} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide up") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_slide_up} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_slide_up} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide down") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_slide_down} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_slide_down} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank on") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::bank_on} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::bank_on} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank left") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_bank_left} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_bank_left} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(11), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank right") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::key_bank_right} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(11), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::key_bank_right} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire primary") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::fire_primary} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::fire_primary} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire secondary") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::fire_secondary} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::fire_secondary} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire flare") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::fire_flare} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::fire_flare} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Accelerate") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::accelerate} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::accelerate} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Reverse") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::reverse} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::reverse} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Drop Bomb") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::drop_bomb} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::drop_bomb} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("REAR VIEW") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::rear_view} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::rear_view} },
#if defined(DXX_BUILD_DESCENT_I)
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cruise Faster") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::cruise_plus} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::cruise_plus} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cruise Slower") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::cruise_minus} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::cruise_minus} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cruise Off") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::cruise_off} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::cruise_off} },
#elif defined(DXX_BUILD_DESCENT_II)
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cruise Faster") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::cruise_plus} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::cruise_plus} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cruise Slower") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::cruise_minus} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::cruise_minus} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(11), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cruise Off") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::cruise_off} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(11), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::cruise_off} },
#endif
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Automap") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::automap} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP2_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::automap} },
#if defined(DXX_BUILD_DESCENT_II)
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Afterburner") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::afterburner} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::afterburner} },
#endif
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(12), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Primary") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::cycle_primary} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(12), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::cycle_primary} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(13), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Second.") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::cycle_secondary} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X1, DXX_KCONFIG_UI_KEYBOARD_X1_GROUP4_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(13), DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::cycle_secondary} },
#if defined(DXX_BUILD_DESCENT_II)
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP5_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(12), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Headlight") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::headlight} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP5_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(12), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::headlight} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP5_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(13), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Energy->Shield") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT1, {&control_info::state_controls_t::energy_to_shield} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP5_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(13), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_BIT2, {&control_info::state_controls_t::energy_to_shield} },
	{DXX_KCONFIG_UI_KEYBOARD_LABEL_X2, DXX_KCONFIG_UI_KEYBOARD_X2_GROUP5_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(14), DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Toggle Bomb") DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::toggle_bomb} },
#endif
};
#endif

#undef DXX_KCONFIG_UI_KEYBOARD_LABEL_X2
#undef DXX_KCONFIG_UI_KEYBOARD_LABEL_X1

#if DXX_MAX_JOYSTICKS
#define DXX_KCONFIG_UI_JOYSTICK_TOP_Y	40
#define DXX_KCONFIG_UI_JOYSTICK_ROW_HEIGHT	8
#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y	(DXX_KCONFIG_UI_JOYSTICK_TOP_Y + (DXX_KCONFIG_UI_JOYSTICK_ROW_HEIGHT * 2))
#define DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y	(DXX_KCONFIG_UI_JOYSTICK_TOP_Y + (DXX_KCONFIG_UI_JOYSTICK_ROW_HEIGHT * 15))

#define DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X1	22
#define DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2	164
#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1	22
#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2	174

#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1	248
#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2	278

#if defined(DXX_BUILD_DESCENT_I)
#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1	104
#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2	133
#elif defined(DXX_BUILD_DESCENT_II)
#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1	102
#define DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2	132
#endif

#define DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X1_C1	73
#define DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X1_CI	121
#define DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_C1	222
#define DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_CI	270

#ifdef kc_item
constexpr kc_item kc_joystick[] = {
#if DXX_MAX_BUTTONS_PER_JOYSTICK || DXX_MAX_HATS_PER_JOYSTICK
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire primary") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::fire_primary} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire secondary") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::fire_secondary} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Accelerate") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::accelerate} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Reverse") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::reverse} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire flare") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::fire_flare} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide on") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::slide_on} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide left") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::btn_slide_left} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide right") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::btn_slide_right} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide up") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::btn_slide_up} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide down") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::btn_slide_down} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank on") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::bank_on} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank left") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::btn_bank_left} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank right") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::btn_bank_right} },
#endif
#if DXX_MAX_AXES_PER_JOYSTICK
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(pitch_ud) DXX_KCONFIG_UI_LABEL("Pitch U/D") DXX_KCONFIG_UI_UDLR(), BT_JOY_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X1_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_pitch) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(turn) DXX_KCONFIG_UI_LABEL("Turn L/R") DXX_KCONFIG_UI_UDLR(), BT_JOY_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X1_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_turn) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(slide_lr) DXX_KCONFIG_UI_LABEL("Slide L/R") DXX_KCONFIG_UI_UDLR(), BT_JOY_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_slide_lr) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(slide_ud) DXX_KCONFIG_UI_LABEL("Slide U/D") DXX_KCONFIG_UI_UDLR(), BT_JOY_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_slide_ud) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(bank) DXX_KCONFIG_UI_LABEL("Bank L/R") DXX_KCONFIG_UI_UDLR(), BT_JOY_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_bank) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(throttle) DXX_KCONFIG_UI_LABEL("Throttle") DXX_KCONFIG_UI_UDLR(), BT_JOY_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_throttle) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
#endif
#if DXX_MAX_BUTTONS_PER_JOYSTICK || DXX_MAX_HATS_PER_JOYSTICK
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Rear view") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::rear_view} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Drop bomb") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::drop_bomb} },
#if defined(DXX_BUILD_DESCENT_I)
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Automap") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::automap} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::automap} },
#elif defined(DXX_BUILD_DESCENT_II)
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Afterburner") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::afterburner} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Primary") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_primary} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Secondary") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_secondary} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Headlight") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::headlight} },
#endif
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire primary") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::fire_primary} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire secondary") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::fire_secondary} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Accelerate") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::accelerate} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Reverse") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::reverse} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire flare") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::fire_flare} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide on") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::slide_on} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide left") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::btn_slide_left} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide right") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::btn_slide_right} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide up") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::btn_slide_up} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide down") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::btn_slide_down} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank on") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::bank_on} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank left") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::btn_bank_left} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank right") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::btn_bank_right} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Rear view") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::rear_view} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Drop bomb") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::drop_bomb} },
#if defined(DXX_BUILD_DESCENT_I)
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Primary") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_primary} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Secondary") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_secondary} },
#elif defined(DXX_BUILD_DESCENT_II)
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(DXX_KCONFIG_UI_LABEL_BLANK) DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::afterburner} },
#endif
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(DXX_KCONFIG_UI_LABEL_BLANK) DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_primary} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(DXX_KCONFIG_UI_LABEL_BLANK) DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_secondary} },
#if defined(DXX_BUILD_DESCENT_II)
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(DXX_KCONFIG_UI_LABEL_BLANK) DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::headlight} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Automap") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::automap} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::automap} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Energy->Shield") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::energy_to_shield} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::energy_to_shield} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Toggle Bomb") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::toggle_bomb} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(10), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::toggle_bomb} },
#endif
#if defined(DXX_BUILD_DESCENT_I)
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Menu") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::show_menu} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::show_menu} },
#elif defined(DXX_BUILD_DESCENT_II)
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(11), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Menu") DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT3, {&control_info::state_controls_t::show_menu} },
	{DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT(11), DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_BIT4, {&control_info::state_controls_t::show_menu} },
#endif
#endif
};
#endif

#undef DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_CI
#undef DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X2_C1
#undef DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X1_CI
#undef DXX_KCONFIG_UI_JOYSTICK_AXES_INPUT_X1_C1
#undef DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C2
#undef DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X2_C1
#undef DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C2
#undef DXX_KCONFIG_UI_JOYSTICK_BUTTONS_INPUT_X1_C1
#undef DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X2
#undef DXX_KCONFIG_UI_JOYSTICK_BUTTONS_LABEL_X1
#undef DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X2
#undef DXX_KCONFIG_UI_JOYSTICK_AXES_LABEL_X1
#undef DXX_KCONFIG_UI_JOYSTICK_BUTTONS_TOP_Y

#endif

#define DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1	25
#define DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1	110
#define DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2	180
#define DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2	239
#define DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_C1	83
#define DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_CI	131
#define DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X2_C1	238
#define DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X2_CI	286
#define DXX_KCONFIG_UI_MOUSE_TOP_Y	46
#define DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y	DXX_KCONFIG_UI_MOUSE_TOP_Y
#define DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y	DXX_KCONFIG_UI_MOUSE_TOP_Y + 108

#ifdef kc_item
constexpr kc_item kc_mouse[] = {
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire primary") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::fire_primary} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire secondary") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::fire_secondary} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Accelerate") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::accelerate} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("reverse") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::reverse} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Fire flare") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::fire_flare} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide on") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::slide_on} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide left") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::btn_slide_left} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide right") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::btn_slide_right} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide up") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::btn_slide_up} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Slide down") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::btn_slide_down} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank on") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::bank_on} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank left") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::btn_bank_left} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Bank right") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::btn_bank_right} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(pitch_ud) DXX_KCONFIG_UI_LABEL("Pitch U/D") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_pitch) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(turn) DXX_KCONFIG_UI_LABEL("Turn L/R") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_turn) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(slide_lr) DXX_KCONFIG_UI_LABEL("Slide L/R") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_slide_lr) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(slide_ud) DXX_KCONFIG_UI_LABEL("Slide U/D") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_slide_ud) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(bank) DXX_KCONFIG_UI_LABEL("Bank L/R") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X2_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_bank) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X2_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_ENUM(throttle) DXX_KCONFIG_UI_LABEL("Throttle") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_AXIS, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2, DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X2_CI, DXX_KCONFIG_UI_INVERT_FLAG_WIDTH, DXX_KCONFIG_UI_ENUM(invert_throttle) DXX_KCONFIG_UI_UDLR(), BT_INVERT, STATE_NONE, {nullptr} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("REAR VIEW") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::rear_view} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Drop Bomb") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::drop_bomb} },
#if defined(DXX_BUILD_DESCENT_I)
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Primary") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_primary} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Secondary") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_secondary} },
#elif defined(DXX_BUILD_DESCENT_II)
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Afterburner") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_BIT5, {&control_info::state_controls_t::afterburner} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Primary") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_primary} },
	{DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1, DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL("Cycle Secondary") DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::cycle_secondary} },
#endif
};
#endif

#define DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1	15
#define DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1	157
#define DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2	215
#define DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3	273
#define DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y	69

#ifdef kc_item
constexpr kc_item kc_rebirth[] = {
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_LASER) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 0), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_VULCAN) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 1), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_SPREADFIRE) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 2), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_PLASMA) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 3), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_FUSION) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 4), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_CONCUSSION) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 5), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_HOMING) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 6), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_PROXIMITY) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 7), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_SMART) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 8), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_LABEL(WEAPON_STRING_MEGA) DXX_KCONFIG_UI_UDLR(), BT_KEY, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2, DXX_KCONFIG_ITEM_JOY_WIDTH(DXX_KCONFIG_UI_CELL_WIDTH), DXX_KCONFIG_UI_UDLR(), BT_JOY_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
	{DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1, DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y + DXX_KCONFIG_UI_ROW_CELL_HEIGHT( 9), DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3, DXX_KCONFIG_UI_CELL_WIDTH, DXX_KCONFIG_UI_UDLR(), BT_MOUSE_BUTTON, STATE_NONE, {&control_info::state_controls_t::select_weapon} },
};
#endif

#undef DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C3
#undef DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C2
#undef DXX_KCONFIG_UI_WEAPON_KEYS_INPUT_X1_C1
#undef DXX_KCONFIG_UI_WEAPON_KEYS_LABEL_X1
#undef DXX_KCONFIG_UI_WEAPON_KEYS_TOP_Y

#undef DXX_KCONFIG_UI_MOUSE_AXES_TOP_Y
#undef DXX_KCONFIG_UI_MOUSE_BUTTONS_TOP_Y
#undef DXX_KCONFIG_UI_MOUSE_TOP_Y
#undef DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X2_CI
#undef DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X2_C1
#undef DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_CI
#undef DXX_KCONFIG_UI_MOUSE_AXES_INPUT_X1_C1
#undef DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X2
#undef DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X2
#undef DXX_KCONFIG_UI_MOUSE_BUTTONS_INPUT_X1
#undef DXX_KCONFIG_UI_MOUSE_BUTTONS_LABEL_X1
#undef DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C2
#undef DXX_KCONFIG_UI_KEYBOARD_INPUT_X2_C1
#undef DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C2
#undef DXX_KCONFIG_UI_KEYBOARD_INPUT_X1_C1
#undef DXX_KCONFIG_UI_KEYBOARD_X2_GROUP5_Y
#undef DXX_KCONFIG_UI_KEYBOARD_X2_GROUP4_Y
#undef DXX_KCONFIG_UI_KEYBOARD_X2_GROUP3_Y
#undef DXX_KCONFIG_UI_KEYBOARD_X2_GROUP2_Y
#undef DXX_KCONFIG_UI_KEYBOARD_X2_GROUP1_Y
#undef DXX_KCONFIG_UI_KEYBOARD_X1_GROUP4_Y
#undef DXX_KCONFIG_UI_KEYBOARD_X1_GROUP3_Y
#undef DXX_KCONFIG_UI_KEYBOARD_X1_GROUP2_Y
#undef DXX_KCONFIG_UI_KEYBOARD_X1_GROUP1_Y

#undef DXX_KCONFIG_UI_CELL_WIDTH
#undef DXX_KCONFIG_UI_ROW_SEPARATOR_HEIGHT
#undef DXX_KCONFIG_UI_ROW_CELL_HEIGHT
#undef DXX_KCONFIG_UI_INVERT_FLAG_WIDTH
#undef DXX_KCONFIG_UI_LABEL_BLANK
#undef DXX_KCONFIG_UI_UDLR
#undef DXX_KCONFIG_UI_UDLR2
#undef DXX_KCONFIG_UI_UDLR3
