/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.Array;
import io.jenetics.internal.collection.ArrayMSeq;
import io.jenetics.internal.collection.ArraySeq;
import io.jenetics.internal.collection.Empty;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import java.util.function.Function;

public class ArrayISeq<T>
extends ArraySeq<T>
implements ISeq<T> {
    private static final long serialVersionUID = 1L;

    public ArrayISeq(Array<T> array2) {
        super(array2);
        assert (array2.isSealed());
    }

    @Override
    public <B> ISeq<B> map(Function<? super T, ? extends B> mapper) {
        Array<B> mapped = Array.ofLength(this.length());
        for (int i = 0; i < this.length(); ++i) {
            mapped.set(i, mapper.apply(this.array.get(i)));
        }
        return new ArrayISeq(mapped.seal());
    }

    @Override
    public ISeq<T> append(Iterable<? extends T> values) {
        return new ArrayISeq<T>(this.__append(values).seal());
    }

    @Override
    public ISeq<T> prepend(Iterable<? extends T> values) {
        return new ArrayISeq<T>(this.__prepend(values).seal());
    }

    @Override
    public ISeq<T> subSeq(int start) {
        if (start < 0 || start > this.length()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Index %d range: [%d..%d)", start, 0, this.length()));
        }
        return start == this.length() ? Empty.iseq() : new ArrayISeq(this.array.slice(start, this.length()));
    }

    @Override
    public ISeq<T> subSeq(int start, int end) {
        if (start > end) {
            throw new ArrayIndexOutOfBoundsException(String.format("start[%d] > end[%d]", start, end));
        }
        if (start < 0 || end > this.length()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Indexes (%d, %d) range: [%d..%d)", start, end, 0, this.length()));
        }
        return start == end ? Empty.iseq() : new ArrayISeq(this.array.slice(start, end));
    }

    @Override
    public MSeq<T> copy() {
        return this.isEmpty() ? Empty.mseq() : new ArrayMSeq(this.array.copy());
    }
}

