/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.ssh;

import com.google.common.base.Preconditions;
import com.google.common.io.CharStreams;
import com.google.common.io.LineProcessor;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collections;
import org.apache.commons.codec.binary.Base64;

public class SshRsaCrypto {
    public static final String RSA = "RSA";

    private BigInteger readAsnInteger(DataInputStream in) throws IOException {
        Preconditions.checkArgument((in.read() == 2 ? 1 : 0) != 0, (Object)"no INTEGER marker");
        int length = in.read();
        if (length >= 128) {
            byte[] extended = new byte[length & 0x7F];
            in.readFully(extended);
            length = new BigInteger(extended).intValue();
        }
        byte[] data = new byte[length];
        in.readFully(data);
        return new BigInteger(data);
    }

    public PrivateKey readPrivateKey(byte[] bytes) throws GeneralSecurityException, IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            Preconditions.checkArgument((in.read() == 48 ? 1 : 0) != 0, (Object)"no id_rsa SEQUENCE");
            Preconditions.checkArgument((in.read() == 130 ? 1 : 0) != 0, (Object)"no Version marker");
            in.skipBytes(5);
            BigInteger n = this.readAsnInteger(in);
            this.readAsnInteger(in);
            BigInteger e = this.readAsnInteger(in);
            RSAPrivateKeySpec spec = new RSAPrivateKeySpec(n, e);
            PrivateKey privateKey = KeyFactory.getInstance(RSA).generatePrivate(spec);
            return privateKey;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                in.close();
            }
        }
    }

    public PublicKey readPublicKey(byte[] bytes) throws GeneralSecurityException, IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            byte[] sshRsa = new byte[in.readInt()];
            in.readFully(sshRsa);
            Preconditions.checkArgument((boolean)new String(sshRsa).equals("ssh-rsa"), (Object)"no RFC-4716 ssh-rsa");
            byte[] exp = new byte[in.readInt()];
            in.readFully(exp);
            byte[] mod = new byte[in.readInt()];
            in.readFully(mod);
            BigInteger e = new BigInteger(exp);
            BigInteger n = new BigInteger(mod);
            RSAPublicKeySpec spec = new RSAPublicKeySpec(n, e);
            PublicKey publicKey = KeyFactory.getInstance(RSA).generatePublic(spec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                in.close();
            }
        }
    }

    public byte[] slurpPrivateKey(String body) throws IOException {
        String ascii = (String)CharStreams.readLines((Readable)new StringReader(body), (LineProcessor)new LineProcessor<String>(){
            StringBuilder builder = new StringBuilder();

            public boolean processLine(String line) throws IOException {
                if (!line.contains("-") && !line.contains(":")) {
                    this.builder.append(line);
                    this.builder.append("\n");
                }
                return true;
            }

            public String getResult() {
                return this.builder.toString();
            }
        });
        Base64 b64 = new Base64();
        return b64.decode(ascii);
    }

    public byte[] slurpPublicKey(String body) throws IOException {
        String[] contents = body.split(" ");
        Preconditions.checkArgument((contents.length == 3 ? 1 : 0) != 0, (Object)"not a valid id_rsa.pub");
        Base64 b64 = new Base64();
        return b64.decode(contents[1]);
    }
}

