/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.switchacl;

import com.ubnt.data.Device;
import com.ubnt.data.Setting;
import com.ubnt.data.Site;
import com.ubnt.model.api.switchacl.AclEntryCount;
import com.ubnt.model.api.switchacl.AclRuleDto;
import com.ubnt.model.api.switchacl.BatchAclRuleUpdatePartDto;
import com.ubnt.model.api.switchacl.CombinedAclRuleOriginType;
import com.ubnt.net.v2.V2RestController;
import com.ubnt.service.config.do;
import com.ubnt.service.devmgr.OoOo0;
import com.ubnt.service.object.oriented.network.ooOO;
import com.ubnt.service.setting.N.new;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.switchacl.D;
import com.ubnt.service.switchacl.O;
import com.ubnt.service.switchacl.V;
import com.ubnt.service.system.setting.M;
import com.ubnt.service.system.setting.OooO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@V2RestController
@Validated
@Tag(name="Switch ACL Rules")
public class AclRuleController {
    private final O o00000;
    private final V Object;
    private final OoOo0 void;
    private final new \u00d500000;
    private final M \u00d600000;
    private final ooOO \u00d400000;
    private final do \u00d200000;

    public AclRuleController(O o2, V v2, OoOo0 ooOo0, new new_, M m2, ooOO ooOO2, do do_) {
        this.o00000 = o2;
        this.Object = v2;
        this.void = ooOo0;
        this.\u00d500000 = new_;
        this.\u00d600000 = m2;
        this.\u00d400000 = ooOO2;
        this.\u00d200000 = do_;
    }

    @GetMapping(value={"/api/site/{siteName}/{mac}/acl-entry-count"})
    @Operation(summary="ACL Entry Count")
    public AclEntryCount getAclEntryCount(@PathVariable(value="siteName") Site site, @PathVariable(value="mac") String string) {
        String string2 = site.getId();
        if (!this.void.\u00d6\u00f4OO00(string2, string, Device::supportsSwitchAccessControlList)) {
            return AclEntryCount.empty();
        }
        Setting setting = this.\u00d600000.\u00d300000(OooO.\u00f8O0000, string2);
        int n2 = this.\u00d500000.Object(string2, setting);
        int n3 = this.Object.\u00d500000(string2, string);
        return AclEntryCount.builder().globalAclEntryCount(n2).customIpAclEntryCount(n3).customMacAclEntryCount(0).build();
    }

    @GetMapping(value={"/api/site/{siteName}/acl-rules"})
    @Operation(summary="List ACL Rules")
    public List<AclRuleDto> listAclRules(@PathVariable(value="siteName") Site site) {
        Stream<AclRuleDto> stream = this.\u00d300000(site);
        Stream<AclRuleDto> stream2 = this.super(site);
        return Stream.concat(stream, stream2).toList();
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Create a new ACL Rule")
    @ResponseStatus(value=HttpStatus.CREATED)
    public AclRuleDto createAclRule(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDocument aclRuleDocument = this.o00000.void(aclRuleDto.toDocument(site.getId()));
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"}, consumes={"application/json"})
    @Operation(summary="Update ACL Rule")
    public AclRuleDto updateAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string, @RequestBody @Valid @NotNull AclRuleDto aclRuleDto) {
        AclRuleDto aclRuleDto2 = AclRuleDto.withId(aclRuleDto, string);
        AclRuleDocument aclRuleDocument = this.o00000.o00000(aclRuleDto2.toDocument(site.getId()));
        return AclRuleDto.fromDocument(aclRuleDocument);
    }

    @PutMapping(value={"/api/site/{siteName}/acl-rules"}, consumes={"application/json"})
    @Operation(summary="Update Selected Properties of ACL Rules in Batch")
    public List<AclRuleDto> batchUpdateAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<BatchAclRuleUpdatePartDto> list) {
        List<D> list2 = list.stream().map(BatchAclRuleUpdatePartDto::toBatchUpdatePart).toList();
        return this.o00000.\u00d600000(site.getId(), list2).stream().map(AclRuleDto::fromDocument).toList();
    }

    @DeleteMapping(value={"/api/site/{siteName}/acl-rules/{ruleId}"})
    @Operation(summary="Delete ACL Rule")
    public void deleteAclRule(@PathVariable(value="siteName") Site site, @PathVariable(value="ruleId") String string) {
        this.o00000.\u00d400000(site.getId(), string);
    }

    @PostMapping(value={"/api/site/{siteName}/acl-rules/batch-delete"}, consumes={"application/json"})
    @Operation(summary="Delete ACL Rules in Batch")
    public void deleteAclRules(@PathVariable(value="siteName") Site site, @RequestBody @Valid @NotEmpty List<String> list) {
        this.o00000.Object(site.getId(), list);
    }

    private Stream<AclRuleDto> super(Site site) {
        Device device = this.void.\u00d2\u00d6OO00(site.getId());
        if (device == null) {
            return Stream.empty();
        }
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return this.\u00d400000.\u00d300000(this.\u00d200000.\u00d400000(device)).stream().map(aclRuleDocument -> AclRuleDto.builderFromDocument(aclRuleDocument).predefined(true).originType(CombinedAclRuleOriginType.OBJECT_ACL_RULE).originId(aclRuleDocument.getId()).id("obj_" + aclRuleDocument.getId() + "_" + atomicInteger.incrementAndGet()).build());
    }

    private Stream<AclRuleDto> \u00d300000(Site site) {
        return this.o00000.\u00d500000(site.getId()).stream().map(AclRuleDto::fromDocument);
    }
}

