/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.net.v2.object.oriented.network;

import com.ubnt.ace.F;
import com.ubnt.ace.W;
import com.ubnt.data.NetworkConf;
import com.ubnt.model.api.IpVersion;
import com.ubnt.model.api.object.oriented.network.ObjectOrientedNetworkConfigDto;
import com.ubnt.model.api.object.oriented.network.ObjectOrientedNetworkSecureMode;
import com.ubnt.model.api.trafficroute.TrafficRouteMatchingTarget;
import com.ubnt.model.schedule.ScheduleDocumentPart;
import com.ubnt.model.schedule.ScheduleDto;
import com.ubnt.net.v2.object.oriented.network.ObjectOrientedNetworkDocumentConverter;
import com.ubnt.net.v2.object.oriented.network.exception.InvalidObjectOrientedNetworkConfigField;
import com.ubnt.net.v2.object.oriented.network.exception.InvalidObjectOrientedNetworkConfigState;
import com.ubnt.net.void.A;
import com.ubnt.service.firewall.o0OO;
import com.ubnt.service.firewall.policy.C;
import com.ubnt.service.firewall.policy.O0oo;
import com.ubnt.service.firewall.policy.R;
import com.ubnt.service.firewall.policy.zone.B;
import com.ubnt.service.firewall.qos.A.J;
import com.ubnt.service.firewall.qos.O;
import com.ubnt.service.firewall.qos.OooO;
import com.ubnt.service.firewall.qos.destination.FirewallQosDestinationWebDocumentPart;
import com.ubnt.service.firewall.qos.new;
import com.ubnt.service.firewall.qos.oooO;
import com.ubnt.service.object.oriented.network.ObjectOrientedNetworkConfigDocument;
import com.ubnt.service.switchacl.AclRuleDocument;
import com.ubnt.service.switchacl.o00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO;
import com.ubnt.service.system.mA;
import com.ubnt.service.traffic.O0OO;
import com.ubnt.service.traffic.TrafficDomainDocumentPart;
import com.ubnt.service.traffic.TrafficIpDocumentPart;
import com.ubnt.service.trafficroute.ooOO;
import jakarta.annotation.Nullable;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ObjectOrientedNetworkConfigValidator {
    private static final Logger \u00f800000 = mA.nullsuper;
    private final C \u00d400000;
    private final com.ubnt.service.firewall.C \u00d200000;
    private final O0oo OO0000;
    private final com.ubnt.service.firewall.policy.zone.A \u00f400000;
    private final ooOO int;
    private final O0OO class;
    private final OooO \u00d800000;
    private final new \u00d300000;
    private final o00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO super;
    private final com.ubnt.service.object.oriented.network.ooOO \u00f600000;
    private final o0OO \u00d600000;

    public void validate(String string, ObjectOrientedNetworkConfigDto objectOrientedNetworkConfigDto) {
        this.oo0000(objectOrientedNetworkConfigDto);
        this.Stringsuper(string, objectOrientedNetworkConfigDto.qos());
        this.\u00d3O0000(string, objectOrientedNetworkConfigDto.route());
        this.oO0000(string, objectOrientedNetworkConfigDto.secure());
        this.\u00d400000(ObjectOrientedNetworkDocumentConverter.toDocument(string, objectOrientedNetworkConfigDto));
    }

    private void oo0000(ObjectOrientedNetworkConfigDto objectOrientedNetworkConfigDto) {
        List<String> list = objectOrientedNetworkConfigDto.targets();
        switch (objectOrientedNetworkConfigDto.targetType()) {
            case CLIENTS: {
                if (!list.stream().anyMatch(string -> !A.\u00f600000(string, false))) break;
                throw new InvalidObjectOrientedNetworkConfigField("Not all clients are valid mac in 'targets'", "targets");
            }
        }
    }

    private void Stringsuper(String string, @Nullable ObjectOrientedNetworkConfigDto.QosDto qosDto) {
        if (qosDto == null || !qosDto.enabled().booleanValue()) {
            return;
        }
        if (BooleanUtils.isTrue((Boolean)qosDto.allTraffic())) {
            if (ObjectOrientedNetworkConfigValidator.\u00d800000(qosDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.apps cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(qosDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.domains cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.while(qosDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.ip_addresses cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(qosDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("qos.regions cannot be enabled together with all traffic");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.\u00d800000(qosDto.apps()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(qosDto.domains()) || ObjectOrientedNetworkConfigValidator.while(qosDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(qosDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for qos");
        }
        this.\u00f5O0000("qos.domains", string, qosDto.domains());
        this.OO0000(qosDto, string);
        this.o00000(qosDto);
        this.\u00d4O0000("qos.apps", qosDto.apps());
        this.\u00d4o0000("qos.regions", qosDto.regions());
        this.Oo0000("qos.ip_addresses", qosDto.ipAddresses());
        ScheduleDocumentPart scheduleDocumentPart = ScheduleDto.toDocument(qosDto.schedule());
        if (scheduleDocumentPart != null) {
            try {
                this.\u00d600000.\u00d600000(scheduleDocumentPart);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid 'qos.schedule' field", "qos.schedule");
            }
        }
    }

    private void \u00d3O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        if (routeDto == null || !routeDto.enabled().booleanValue()) {
            return;
        }
        if (BooleanUtils.isTrue((Boolean)routeDto.allTraffic())) {
            if (ObjectOrientedNetworkConfigValidator.\u00d800000(routeDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.apps cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(routeDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.domains cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.while(routeDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.ip_addresses cannot be enabled together with all traffic");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(routeDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("route.regions cannot be enabled together with all traffic");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.\u00d800000(routeDto.apps()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(routeDto.domains()) || ObjectOrientedNetworkConfigValidator.while(routeDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(routeDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for route");
        }
        NetworkConf networkConf = this.\u00f500000(routeDto, string);
        this.\u00d5O0000("route.domains", string, routeDto.domains());
        this.\u00d8O0000("route.ip_addresses", networkConf, routeDto);
        this.\u00d4o0000("route.regions", routeDto.regions());
        ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList = routeDto.apps();
        if (integerValuesList != null && integerValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Route doesn't support applications", "route.apps");
        }
    }

    private void oO0000(String string, @Nullable ObjectOrientedNetworkConfigDto.SecureDto secureDto) {
        if (secureDto == null || !secureDto.enabled().booleanValue()) {
            return;
        }
        this.validate(secureDto.internet());
        this.if(string, secureDto.local());
    }

    private void \u00d400000(ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument) {
        if (objectOrientedNetworkConfigDocument.isSecureEnabled()) {
            this.\u00d300000(objectOrientedNetworkConfigDocument);
        }
    }

    private void \u00d300000(ObjectOrientedNetworkConfigDocument objectOrientedNetworkConfigDocument) {
        List<AclRuleDocument> list = this.\u00f600000.\u00d200000(objectOrientedNetworkConfigDocument);
        this.super.\u00d4\u00d20000(objectOrientedNetworkConfigDocument.siteId(), objectOrientedNetworkConfigDocument, list);
    }

    public void validate(@Nullable ObjectOrientedNetworkConfigDto.SecureDto.InternetSectionDto internetSectionDto) {
        if (internetSectionDto == null) {
            return;
        }
        switch (internetSectionDto.mode()) {
            case ALLOWLIST: 
            case BLOCKLIST: 
            case TURN_OFF_INTERNET: {
                break;
            }
            default: {
                String string = "secure.internet.mode";
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        }
        ObjectOrientedNetworkSecureMode objectOrientedNetworkSecureMode = internetSectionDto.mode();
        if (objectOrientedNetworkSecureMode == ObjectOrientedNetworkSecureMode.TURN_OFF_INTERNET) {
            if (BooleanUtils.isTrue((Boolean)internetSectionDto.everything()) || ObjectOrientedNetworkConfigValidator.\u00d800000(internetSectionDto.apps()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(internetSectionDto.domains()) || ObjectOrientedNetworkConfigValidator.while(internetSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(internetSectionDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("Nothing can be enabled with 'TURN_OFF_INTERNET' mode");
            }
            return;
        }
        if (BooleanUtils.isTrue((Boolean)internetSectionDto.everything())) {
            if (ObjectOrientedNetworkConfigValidator.\u00d800000(internetSectionDto.apps())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.apps cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(internetSectionDto.domains())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.domains cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.while(internetSectionDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.ip_addresses cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(internetSectionDto.regions())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.internet.regions cannot be enabled together with everything");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.\u00d800000(internetSectionDto.apps()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(internetSectionDto.domains()) || ObjectOrientedNetworkConfigValidator.while(internetSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(internetSectionDto.regions()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for secure.internet");
        }
        this.\u00d4O0000("secure.internet.apps", internetSectionDto.apps());
        this.\u00f800000("secure.internet.domains", internetSectionDto.domains());
        this.Oo0000("secure.internet.ip_addresses", internetSectionDto.ipAddresses());
        this.\u00d4o0000("secure.internet.regions", internetSectionDto.regions());
        ScheduleDocumentPart scheduleDocumentPart = ScheduleDto.toDocument(internetSectionDto.schedule());
        if (scheduleDocumentPart != null) {
            try {
                this.\u00d600000.\u00d600000(scheduleDocumentPart);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid 'internet.schedule' field", "internet.schedule");
            }
        }
    }

    private void if(String string, @Nullable ObjectOrientedNetworkConfigDto.SecureDto.LocalSectionDto localSectionDto) {
        if (localSectionDto == null) {
            return;
        }
        switch (localSectionDto.mode()) {
            case ALLOWLIST: 
            case BLOCKLIST: 
            case QUARANTINE: {
                break;
            }
            default: {
                String string2 = "secure.local.mode";
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
            }
        }
        ObjectOrientedNetworkSecureMode objectOrientedNetworkSecureMode = localSectionDto.mode();
        if (objectOrientedNetworkSecureMode == ObjectOrientedNetworkSecureMode.QUARANTINE) {
            if (BooleanUtils.isTrue((Boolean)localSectionDto.everything()) || ObjectOrientedNetworkConfigValidator.return(localSectionDto.devices()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(localSectionDto.networks()) || ObjectOrientedNetworkConfigValidator.while(localSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.return(localSectionDto.macAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("Nothing can be enabled with 'QUARANTINE' mode");
            }
            return;
        }
        if (BooleanUtils.isTrue((Boolean)localSectionDto.everything())) {
            if (ObjectOrientedNetworkConfigValidator.return(localSectionDto.devices())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.devices cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(localSectionDto.networks())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.networks cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.while(localSectionDto.ipAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.ip_addresses cannot be enabled together with everything");
            }
            if (ObjectOrientedNetworkConfigValidator.return(localSectionDto.macAddresses())) {
                throw new InvalidObjectOrientedNetworkConfigState("secure.local.mac_addresses cannot be enabled together with everything");
            }
        } else if (!(ObjectOrientedNetworkConfigValidator.return(localSectionDto.devices()) || ObjectOrientedNetworkConfigValidator.\u00f8O0000(localSectionDto.networks()) || ObjectOrientedNetworkConfigValidator.while(localSectionDto.ipAddresses()) || ObjectOrientedNetworkConfigValidator.return(localSectionDto.macAddresses()))) {
            throw new InvalidObjectOrientedNetworkConfigState("No any enabled option for secure.local");
        }
        this.\u00f400000("secure.local.devices", localSectionDto.devices());
        this.\u00f4o0000("secure.local.networks", string, localSectionDto.networks());
        this.Oo0000("secure.local.ip_addresses", localSectionDto.ipAddresses());
    }

    private void Oo0000(String string, @Nullable ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList) {
        if (ipAddressesValuesList == null) {
            return;
        }
        List<String> list = ipAddressesValuesList.values();
        if (!list.isEmpty()) {
            try {
                this.\u00d200000.o00000(list, com.ubnt.service.firewall.B.\u00d300000, R.\u00d500000);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (ipAddressesValuesList.enabled().booleanValue()) {
            throw new IllegalStateException("'%s' should not be empty".formatted(string));
        }
    }

    private void \u00d8O0000(String string, NetworkConf networkConf, ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList = routeDto.ipAddresses();
        if (ipAddressesValuesList == null) {
            return;
        }
        List<String> list = ipAddressesValuesList.values();
        if (!list.isEmpty()) {
            List<TrafficIpDocumentPart> list2 = ObjectOrientedNetworkConfigValidator.\u00d3o0000(list);
            try {
                this.int.oO0000(networkConf, list2, List.of(), TrafficRouteMatchingTarget.IP);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (ipAddressesValuesList.enabled().booleanValue()) {
            throw new IllegalStateException("'%s' should not be empty".formatted(string));
        }
    }

    private void \u00d4o0000(String string, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            try {
                this.class.\u00d8o0000(list);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00f5O0000(String string, String string2, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            FirewallQosDestinationWebDocumentPart firewallQosDestinationWebDocumentPart = FirewallQosDestinationWebDocumentPart.builder().\u00d400000(list).OO0000(oooO.\u00d500000).\u00d300000(com.ubnt.service.firewall.policy.O.String).\u00f400000();
            try {
                this.\u00d300000.\u00f600000(firewallQosDestinationWebDocumentPart, string2);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void OO0000(ObjectOrientedNetworkConfigDto.QosDto qosDto, String string) {
        String string2 = qosDto.networkId();
        try {
            this.\u00d800000.\u00d5O0000(string2, string);
        }
        catch (com.ubnt.service.firewall.qos.A.OooO oooO2) {
            \u00f800000.warn(oooO2.getMessage(), (Throwable)oooO2);
            throw new InvalidObjectOrientedNetworkConfigField("Invalid 'qos.network_id'", "qos.network_id");
        }
    }

    private void o00000(ObjectOrientedNetworkConfigDto.QosDto qosDto) {
        O o2 = qosDto.mode().qosRuleObjective();
        Integer n2 = W.\u00f6O0000(qosDto.downloadLimit(), speedLimitDto -> speedLimitDto != null && speedLimitDto.enabled() != false, ObjectOrientedNetworkConfigDto.QosDto.SpeedLimitDto::limit);
        Integer n3 = W.\u00f6O0000(qosDto.uploadLimit(), speedLimitDto -> speedLimitDto != null && speedLimitDto.enabled() != false, ObjectOrientedNetworkConfigDto.QosDto.SpeedLimitDto::limit);
        try {
            this.\u00d800000.o00000(o2, n2, n3);
        }
        catch (J j2) {
            \u00f800000.warn(j2.getMessage(), (Throwable)j2);
            throw new InvalidObjectOrientedNetworkConfigField(j2.getMessage(), "qos.download_limit|qos.upload_limit");
        }
    }

    private void \u00d5O0000(String string2, String string3, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            List<TrafficDomainDocumentPart> list2 = list.stream().map(string -> TrafficDomainDocumentPart.builder().OO0000((String)string).\u00d600000()).toList();
            try {
                this.class.floatsuper(string3, list2);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string2), string2);
        }
    }

    private void \u00f800000(String string, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            try {
                this.\u00d200000.\u00d800000(list);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00d4O0000(String string, @Nullable ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList) {
        if (integerValuesList == null) {
            return;
        }
        List<Integer> list = integerValuesList.values();
        if (!list.isEmpty()) {
            try {
                this.\u00d200000.\u00f4O0000(list);
            }
            catch (RuntimeException runtimeException) {
                \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
            }
        } else if (integerValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00f4o0000(String string, String string2, @Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        if (stringValuesList == null) {
            return;
        }
        List<String> list = stringValuesList.values();
        if (!list.isEmpty()) {
            List<B> list2 = this.\u00f400000.\u00d500000(this.\u00d400000.\u00d3O0000(string2));
            if (list2.isEmpty()) {
                throw new InvalidObjectOrientedNetworkConfigState("No any available firewall zones to configure networks");
            }
            HashMap<B, Set> hashMap = new HashMap<B, Set>();
            for (String object : list) {
                B b3 = list2.stream().filter(b2 -> b2.\u00d500000().contains(object)).findFirst().orElseThrow(() -> new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string));
                hashMap.computeIfAbsent(b3, b2 -> new HashSet()).add(object);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                try {
                    this.OO0000.\u00d800000((Set)entry.getValue(), (B)entry.getKey());
                }
                catch (RuntimeException runtimeException) {
                    \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
                    throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string), string);
                }
            }
        } else if (stringValuesList.enabled().booleanValue()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private void \u00f400000(String string, @Nullable ObjectOrientedNetworkConfigDto.MacAddressesValuesList macAddressesValuesList) {
        if (macAddressesValuesList == null) {
            return;
        }
        List<String> list = macAddressesValuesList.values();
        if (macAddressesValuesList.enabled().booleanValue() && list.isEmpty()) {
            throw new InvalidObjectOrientedNetworkConfigField("Enabled '%s' cannot be empty".formatted(string), string);
        }
    }

    private NetworkConf \u00f500000(ObjectOrientedNetworkConfigDto.RouteDto routeDto, String string) {
        String string2 = "route.network_id";
        String string3 = routeDto.networkId();
        if (StringUtils.isBlank((CharSequence)string3)) {
            throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
        }
        Set<TrafficRouteMatchingTarget> set = ObjectOrientedNetworkConfigValidator.\u00d5o0000(routeDto);
        try {
            return this.int.\u00f500000(string, string3, set);
        }
        catch (RuntimeException runtimeException) {
            \u00f800000.warn(runtimeException.getMessage(), (Throwable)runtimeException);
            throw new InvalidObjectOrientedNetworkConfigField("Invalid '%s'".formatted(string2), string2);
        }
    }

    private static boolean \u00f8O0000(@Nullable ObjectOrientedNetworkConfigDto.StringValuesList stringValuesList) {
        return stringValuesList != null && stringValuesList.enabled() != false;
    }

    private static boolean while(@Nullable ObjectOrientedNetworkConfigDto.IpAddressesValuesList ipAddressesValuesList) {
        return ipAddressesValuesList != null && ipAddressesValuesList.enabled() != false;
    }

    private static boolean return(@Nullable ObjectOrientedNetworkConfigDto.MacAddressesValuesList macAddressesValuesList) {
        return macAddressesValuesList != null && macAddressesValuesList.enabled() != false;
    }

    private static boolean \u00d800000(@Nullable ObjectOrientedNetworkConfigDto.IntegerValuesList integerValuesList) {
        return integerValuesList != null && integerValuesList.enabled() != false;
    }

    private static Set<TrafficRouteMatchingTarget> \u00d5o0000(ObjectOrientedNetworkConfigDto.RouteDto routeDto) {
        HashSet<TrafficRouteMatchingTarget> hashSet = new HashSet<TrafficRouteMatchingTarget>();
        if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(routeDto.domains())) {
            hashSet.add(TrafficRouteMatchingTarget.DOMAIN);
        }
        if (ObjectOrientedNetworkConfigValidator.while(routeDto.ipAddresses())) {
            hashSet.add(TrafficRouteMatchingTarget.IP);
        }
        if (ObjectOrientedNetworkConfigValidator.\u00f8O0000(routeDto.regions())) {
            hashSet.add(TrafficRouteMatchingTarget.REGION);
        }
        if (BooleanUtils.isTrue((Boolean)routeDto.allTraffic())) {
            hashSet.add(TrafficRouteMatchingTarget.INTERNET);
        }
        return hashSet;
    }

    private static List<TrafficIpDocumentPart> \u00d3o0000(List<String> list) {
        return list.stream().map(string -> TrafficIpDocumentPart.builder().\u00d200000(F.O\u00d50000(string) || F.class(string) ? IpVersion.V6 : IpVersion.V4).Object((String)string).\u00d500000()).toList();
    }

    @ConstructorProperties(value={"firewallPolicyValidator", "firewallSourceDestinationValidationUtils", "firewallPolicySourceDestinationValidationUtils", "firewallZoneMatchingTargetUtils", "trafficRouteValidator", "trafficValidator", "qosRuleValidator", "destinationQosValidator", "aclRuleValidator", "objectOrientedNetworkAclRulesFactory", "firewallScheduleValidator"})
    @Generated
    public ObjectOrientedNetworkConfigValidator(C c2, com.ubnt.service.firewall.C c3, O0oo o0oo2, com.ubnt.service.firewall.policy.zone.A a2, ooOO ooOO2, O0OO o0OO2, OooO oooO2, new new_, o00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO o00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2, com.ubnt.service.object.oriented.network.ooOO ooOO3, o0OO o0OO3) {
        this.\u00d400000 = c2;
        this.\u00d200000 = c3;
        this.OO0000 = o0oo2;
        this.\u00f400000 = a2;
        this.int = ooOO2;
        this.class = o0OO2;
        this.\u00d800000 = oooO2;
        this.\u00d300000 = new_;
        this.super = o00OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO2;
        this.\u00f600000 = ooOO3;
        this.\u00d600000 = o0OO3;
    }
}

