package merkledag_pb

import (
	bytes "bytes"
	"testing"
)

func TestStability(t *testing.T) {
	correct := []byte("\x12\x87\x01\n;\x81\x869\xacH\xa4Ư\xa2\xf1X\x1a\x8b\x95%\xe2\x0f\xdah\x92\u007f+/\xf86\xf75x\xdb\x0f\xa5L)\xf7\xfd\x92\x8d\x92\xcaC\xf1\x93\xde\xe4\u007fY\x15I\xf5\x97\xa8\x11\xc8\xfag\xab\x03\x1e\xbd\x12B|CMw`mHq{>?|vd{0F7>8<B;SUcg1E|NU:>m[C`HSg3UcXmGs-qp-z6{Kc.tGX->H07\x18\xeaئ\xd0\b\x129\x121LZ3,V9jnmk^veYEV71EMLt9;6]}b<OBKeL+0ceE8.SenYYxr,\x18쎔\xc1\x05\x127\n/Z\xb5R\x9dp@t\xafJ\xc8\xc0\xf5\xa4o\tn\xe8GzwT0\x03\x8f\xc0\x0e\xac\x03\xafM\xdc\xd3%\xbd+11\x064\x8a\b\xb8d\"\xf5ݬ\x18\xf5\x8d\xd7\xc7\r\x12b\n<\xaf\xbdm\xdc\b\x0f\x1d\xfd\xc9ĭ%oGV F\xfc@T\xf5\x9b[\xe5F^u\xe6\xe0\xaa`\xc8\xeb.\xe5\xd4\xcd&P\xa8\x1c\xce\xe3U\a\xa1\x1a7\x90q\xc7Q\xf7\x1f\xdf\r\xfe\xb3\xfb\xc8\x12\x1cBe<DTg1rDhlUHMppHvO8n\\C.Go^T\x18\x82\x8b\xd1\xce\x0f\x12f\nY\n\x87\x16\xa9(\xe7ͺ\xeaɿ%\x00\x98IE\xcc\xe5\xdaLo\xb4\x82\x9d\xbbf\x9faD@\xf7\x19.\x14\xea_\xbaI,\x95V\xd7@\x88\xa9\x13.J\\\x13\xcc\x15\x9a\xa6\xebJ\x0e\x9b\x96<\xad\xd1n\x9c-\xba\xfd\xce&\xc7\x18\xbc\xdc\x0f\xa7ԭ\x15^\xeb̹Fq\xe3\xdd\xfbK\x99\x12\x03Xyv\x18\xb3Ր\xb3\r\x12}\nI\x89\xdf\xff\x84\r\xaeʨ\x9b\x8e\xf21\xf6\xf2~\x13\xda\xeb\xe2\xed\xcd\xed\x9f8ƞ\u007fz\xa1\x83N\xda\x01\xe35A \x10\xa6\x11|u\\*{N\x18)\xae\xc7\xc5\x06\xc1d\a\xcc\x17\xb0\x8f\xd5\xd2\xe3Pj\x9aH\x04\xa3\xba{\"\xd1\x15\x12*Y6m[-JhYc}LWlNU533k`>nkU2e7GXmqisoCPV0C+ni\x18Ա\xfe\x8b\f\x12u\n'\xf2#\xc1\xc0nQ\xf9\xb5\x19\x80\xcd\xf8\x06k1\xf6#\x84\x1c\xb6\xbf\xeaY\x9b\xd8O\x84\x04\xdbKq\xe4\xae\xf2\xd6\xe9*\x16B\x12D[gVeg4=t}EGSu82+dmgvQ+Tr>_sLUJ|iZ[P2y2T67ilvEikK}\\iru?IF?mVS[Mv9KG8+\x18\x92\xa0\xf9\xa1\n\n\x11?̎\v\x06ѣ\x80nH\x12\x00\xa7\xd2w͝")
	n := new(PBNode)
	err := n.Unmarshal(correct)
	if err != nil {
		t.Fatal(err)
	}
	d, err := n.Marshal()
	if err != nil {
		t.Fatal(err)
	}
	if !bytes.Equal(d, correct) {
		t.Logf("%q", d)
		t.Fatal("protobuf not stable")
	}

}
