// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientPropertiesRequest
type DescribeClientPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The resource identifier, in the form of directory IDs.
	//
	// ResourceIds is a required field
	ResourceIds []string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeClientPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClientPropertiesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeClientPropertiesInput"}

	if s.ResourceIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientPropertiesResult
type DescribeClientPropertiesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified Amazon WorkSpaces clients.
	ClientPropertiesList []PropertiesResult `type:"list"`
}

// String returns the string representation
func (s DescribeClientPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeClientProperties = "DescribeClientProperties"

// DescribeClientPropertiesRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
//
//    // Example sending a request using DescribeClientPropertiesRequest.
//    req := client.DescribeClientPropertiesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties
func (c *Client) DescribeClientPropertiesRequest(input *DescribeClientPropertiesInput) DescribeClientPropertiesRequest {
	op := &aws.Operation{
		Name:       opDescribeClientProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClientPropertiesInput{}
	}

	req := c.newRequest(op, input, &DescribeClientPropertiesOutput{})
	return DescribeClientPropertiesRequest{Request: req, Input: input, Copy: c.DescribeClientPropertiesRequest}
}

// DescribeClientPropertiesRequest is the request type for the
// DescribeClientProperties API operation.
type DescribeClientPropertiesRequest struct {
	*aws.Request
	Input *DescribeClientPropertiesInput
	Copy  func(*DescribeClientPropertiesInput) DescribeClientPropertiesRequest
}

// Send marshals and sends the DescribeClientProperties API request.
func (r DescribeClientPropertiesRequest) Send(ctx context.Context) (*DescribeClientPropertiesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeClientPropertiesResponse{
		DescribeClientPropertiesOutput: r.Request.Data.(*DescribeClientPropertiesOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeClientPropertiesResponse is the response type for the
// DescribeClientProperties API operation.
type DescribeClientPropertiesResponse struct {
	*DescribeClientPropertiesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeClientProperties request.
func (r *DescribeClientPropertiesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
