// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountRequest
type DescribeAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountResult
type DescribeAccountOutput struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, used for the management
	// network interface.
	//
	// The management network interface is connected to a secure Amazon WorkSpaces
	// management network. It is used for interactive streaming of the WorkSpace
	// desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage
	// the WorkSpace.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL (whether BYOL is enabled or disabled).
	DedicatedTenancySupport DedicatedTenancySupportResultEnum `type:"string" enum:"true"`
}

// String returns the string representation
func (s DescribeAccountOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeAccount = "DescribeAccount"

// DescribeAccountRequest returns a request value for making API operation for
// Amazon WorkSpaces.
//
// Retrieves a list that describes the configuration of bring your own license
// (BYOL) for the specified account.
//
//    // Example sending a request using DescribeAccountRequest.
//    req := client.DescribeAccountRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount
func (c *Client) DescribeAccountRequest(input *DescribeAccountInput) DescribeAccountRequest {
	op := &aws.Operation{
		Name:       opDescribeAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountInput{}
	}

	req := c.newRequest(op, input, &DescribeAccountOutput{})
	return DescribeAccountRequest{Request: req, Input: input, Copy: c.DescribeAccountRequest}
}

// DescribeAccountRequest is the request type for the
// DescribeAccount API operation.
type DescribeAccountRequest struct {
	*aws.Request
	Input *DescribeAccountInput
	Copy  func(*DescribeAccountInput) DescribeAccountRequest
}

// Send marshals and sends the DescribeAccount API request.
func (r DescribeAccountRequest) Send(ctx context.Context) (*DescribeAccountResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeAccountResponse{
		DescribeAccountOutput: r.Request.Data.(*DescribeAccountOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeAccountResponse is the response type for the
// DescribeAccount API operation.
type DescribeAccountResponse struct {
	*DescribeAccountOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeAccount request.
func (r *DescribeAccountResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
