// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthorityRequest
type DisassociateWebsiteCertificateAuthorityInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`

	// A unique identifier for the CA.
	//
	// WebsiteCaId is a required field
	WebsiteCaId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateWebsiteCertificateAuthorityInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateWebsiteCertificateAuthorityInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateWebsiteCertificateAuthorityInput"}

	if s.FleetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetArn", 20))
	}

	if s.WebsiteCaId == nil {
		invalidParams.Add(aws.NewErrParamRequired("WebsiteCaId"))
	}
	if s.WebsiteCaId != nil && len(*s.WebsiteCaId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("WebsiteCaId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateWebsiteCertificateAuthorityInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.WebsiteCaId != nil {
		v := *s.WebsiteCaId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WebsiteCaId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthorityResponse
type DisassociateWebsiteCertificateAuthorityOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateWebsiteCertificateAuthorityOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DisassociateWebsiteCertificateAuthorityOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDisassociateWebsiteCertificateAuthority = "DisassociateWebsiteCertificateAuthority"

// DisassociateWebsiteCertificateAuthorityRequest returns a request value for making API operation for
// Amazon WorkLink.
//
// Removes a certificate authority (CA).
//
//    // Example sending a request using DisassociateWebsiteCertificateAuthorityRequest.
//    req := client.DisassociateWebsiteCertificateAuthorityRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/DisassociateWebsiteCertificateAuthority
func (c *Client) DisassociateWebsiteCertificateAuthorityRequest(input *DisassociateWebsiteCertificateAuthorityInput) DisassociateWebsiteCertificateAuthorityRequest {
	op := &aws.Operation{
		Name:       opDisassociateWebsiteCertificateAuthority,
		HTTPMethod: "POST",
		HTTPPath:   "/disassociateWebsiteCertificateAuthority",
	}

	if input == nil {
		input = &DisassociateWebsiteCertificateAuthorityInput{}
	}

	req := c.newRequest(op, input, &DisassociateWebsiteCertificateAuthorityOutput{})
	return DisassociateWebsiteCertificateAuthorityRequest{Request: req, Input: input, Copy: c.DisassociateWebsiteCertificateAuthorityRequest}
}

// DisassociateWebsiteCertificateAuthorityRequest is the request type for the
// DisassociateWebsiteCertificateAuthority API operation.
type DisassociateWebsiteCertificateAuthorityRequest struct {
	*aws.Request
	Input *DisassociateWebsiteCertificateAuthorityInput
	Copy  func(*DisassociateWebsiteCertificateAuthorityInput) DisassociateWebsiteCertificateAuthorityRequest
}

// Send marshals and sends the DisassociateWebsiteCertificateAuthority API request.
func (r DisassociateWebsiteCertificateAuthorityRequest) Send(ctx context.Context) (*DisassociateWebsiteCertificateAuthorityResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateWebsiteCertificateAuthorityResponse{
		DisassociateWebsiteCertificateAuthorityOutput: r.Request.Data.(*DisassociateWebsiteCertificateAuthorityOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateWebsiteCertificateAuthorityResponse is the response type for the
// DisassociateWebsiteCertificateAuthority API operation.
type DisassociateWebsiteCertificateAuthorityResponse struct {
	*DisassociateWebsiteCertificateAuthorityOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateWebsiteCertificateAuthority request.
func (r *DisassociateWebsiteCertificateAuthorityResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
