// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A request to delete a SqlInjectionMatchSet from AWS WAF.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSqlInjectionMatchSetRequest
type DeleteSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The SqlInjectionMatchSetId of the SqlInjectionMatchSet that you want to delete.
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	//
	// SqlInjectionMatchSetId is a required field
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSqlInjectionMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteSqlInjectionMatchSetInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.SqlInjectionMatchSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SqlInjectionMatchSetId"))
	}
	if s.SqlInjectionMatchSetId != nil && len(*s.SqlInjectionMatchSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SqlInjectionMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to a request to delete a SqlInjectionMatchSet from AWS WAF.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSqlInjectionMatchSetResponse
type DeleteSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteSqlInjectionMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteSqlInjectionMatchSet = "DeleteSqlInjectionMatchSet"

// DeleteSqlInjectionMatchSetRequest returns a request value for making API operation for
// AWS WAF Regional.
//
// Permanently deletes a SqlInjectionMatchSet. You can't delete a SqlInjectionMatchSet
// if it's still used in any Rules or if it still contains any SqlInjectionMatchTuple
// objects.
//
// If you just want to remove a SqlInjectionMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a SqlInjectionMatchSet from AWS WAF, perform the following
// steps:
//
// Update the SqlInjectionMatchSet to remove filters, if any. For more information,
// see UpdateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteSqlInjectionMatchSet request.
//
// Submit a DeleteSqlInjectionMatchSet request.
//
//    // Example sending a request using DeleteSqlInjectionMatchSetRequest.
//    req := client.DeleteSqlInjectionMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/DeleteSqlInjectionMatchSet
func (c *Client) DeleteSqlInjectionMatchSetRequest(input *DeleteSqlInjectionMatchSetInput) DeleteSqlInjectionMatchSetRequest {
	op := &aws.Operation{
		Name:       opDeleteSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSqlInjectionMatchSetInput{}
	}

	req := c.newRequest(op, input, &DeleteSqlInjectionMatchSetOutput{})
	return DeleteSqlInjectionMatchSetRequest{Request: req, Input: input, Copy: c.DeleteSqlInjectionMatchSetRequest}
}

// DeleteSqlInjectionMatchSetRequest is the request type for the
// DeleteSqlInjectionMatchSet API operation.
type DeleteSqlInjectionMatchSetRequest struct {
	*aws.Request
	Input *DeleteSqlInjectionMatchSetInput
	Copy  func(*DeleteSqlInjectionMatchSetInput) DeleteSqlInjectionMatchSetRequest
}

// Send marshals and sends the DeleteSqlInjectionMatchSet API request.
func (r DeleteSqlInjectionMatchSetRequest) Send(ctx context.Context) (*DeleteSqlInjectionMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteSqlInjectionMatchSetResponse{
		DeleteSqlInjectionMatchSetOutput: r.Request.Data.(*DeleteSqlInjectionMatchSetOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteSqlInjectionMatchSetResponse is the response type for the
// DeleteSqlInjectionMatchSet API operation.
type DeleteSqlInjectionMatchSetResponse struct {
	*DeleteSqlInjectionMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteSqlInjectionMatchSet request.
func (r *DeleteSqlInjectionMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
