// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package swf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListWorkflowTypesInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain in which the workflow types have been registered.
	//
	// Domain is a required field
	Domain *string `locationName:"domain" min:"1" type:"string" required:"true"`

	// The maximum number of results that are returned per call. nextPageToken can
	// be used to obtain futher pages of results. The default is 1000, which is
	// the maximum allowed page size. You can, however, specify a page size smaller
	// than the maximum.
	//
	// This is an upper limit only; the actual number of results returned per call
	// may be fewer than the specified maximum.
	MaximumPageSize *int64 `locationName:"maximumPageSize" type:"integer"`

	// If specified, lists the workflow type with this name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// Specifies the registration status of the workflow types to list.
	//
	// RegistrationStatus is a required field
	RegistrationStatus RegistrationStatus `locationName:"registrationStatus" type:"string" required:"true" enum:"true"`

	// When set to true, returns the results in reverse order. By default the results
	// are returned in ascending alphabetical order of the name of the workflow
	// types.
	ReverseOrder *bool `locationName:"reverseOrder" type:"boolean"`
}

// String returns the string representation
func (s ListWorkflowTypesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkflowTypesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListWorkflowTypesInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}
	if s.Domain != nil && len(*s.Domain) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Domain", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.RegistrationStatus) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RegistrationStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains a paginated list of information structures about workflow types.
type ListWorkflowTypesOutput struct {
	_ struct{} `type:"structure"`

	// If a NextPageToken was returned by a previous call, there are more results
	// available. To retrieve the next page of results, make the call again using
	// the returned token in nextPageToken. Keep all other arguments unchanged.
	//
	// The configured maximumPageSize determines how many results can be returned
	// in a single call.
	NextPageToken *string `locationName:"nextPageToken" type:"string"`

	// The list of workflow type information.
	//
	// TypeInfos is a required field
	TypeInfos []WorkflowTypeInfo `locationName:"typeInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s ListWorkflowTypesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListWorkflowTypes = "ListWorkflowTypes"

// ListWorkflowTypesRequest returns a request value for making API operation for
// Amazon Simple Workflow Service.
//
// Returns information about workflow types in the specified domain. The results
// may be split into multiple pages that can be retrieved by making the call
// repeatedly.
//
// Access Control
//
// You can use IAM policies to control this action's access to Amazon SWF resources
// as follows:
//
//    * Use a Resource element with the domain name to limit the action to only
//    specified domains.
//
//    * Use an Action element to allow or deny permission to call this action.
//
//    * You cannot use an IAM policy to constrain this action's parameters.
//
// If the caller doesn't have sufficient permissions to invoke the action, or
// the parameter values fall outside the specified constraints, the action fails.
// The associated event attribute's cause parameter is set to OPERATION_NOT_PERMITTED.
// For details and example IAM policies, see Using IAM to Manage Access to Amazon
// SWF Workflows (http://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html)
// in the Amazon SWF Developer Guide.
//
//    // Example sending a request using ListWorkflowTypesRequest.
//    req := client.ListWorkflowTypesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) ListWorkflowTypesRequest(input *ListWorkflowTypesInput) ListWorkflowTypesRequest {
	op := &aws.Operation{
		Name:       opListWorkflowTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextPageToken"},
			OutputTokens:    []string{"nextPageToken"},
			LimitToken:      "maximumPageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkflowTypesInput{}
	}

	req := c.newRequest(op, input, &ListWorkflowTypesOutput{})
	return ListWorkflowTypesRequest{Request: req, Input: input, Copy: c.ListWorkflowTypesRequest}
}

// ListWorkflowTypesRequest is the request type for the
// ListWorkflowTypes API operation.
type ListWorkflowTypesRequest struct {
	*aws.Request
	Input *ListWorkflowTypesInput
	Copy  func(*ListWorkflowTypesInput) ListWorkflowTypesRequest
}

// Send marshals and sends the ListWorkflowTypes API request.
func (r ListWorkflowTypesRequest) Send(ctx context.Context) (*ListWorkflowTypesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListWorkflowTypesResponse{
		ListWorkflowTypesOutput: r.Request.Data.(*ListWorkflowTypesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListWorkflowTypesRequestPaginator returns a paginator for ListWorkflowTypes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListWorkflowTypesRequest(input)
//   p := swf.NewListWorkflowTypesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListWorkflowTypesPaginator(req ListWorkflowTypesRequest) ListWorkflowTypesPaginator {
	return ListWorkflowTypesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListWorkflowTypesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListWorkflowTypesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListWorkflowTypesPaginator struct {
	aws.Pager
}

func (p *ListWorkflowTypesPaginator) CurrentPage() *ListWorkflowTypesOutput {
	return p.Pager.CurrentPage().(*ListWorkflowTypesOutput)
}

// ListWorkflowTypesResponse is the response type for the
// ListWorkflowTypes API operation.
type ListWorkflowTypesResponse struct {
	*ListWorkflowTypesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListWorkflowTypes request.
func (r *ListWorkflowTypesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
