// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package storagegateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A JSON object that contains one or more of the following fields:
//
//    * ListVolumesInput$Limit
//
//    * ListVolumesInput$Marker
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumesInput
type ListVolumesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// Specifies that the list of volumes returned be limited to the specified number
	// of items.
	Limit *int64 `min:"1" type:"integer"`

	// A string that indicates the position at which to begin the returned list
	// of volumes. Obtain the marker from the response of a previous List iSCSI
	// Volumes request.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListVolumesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVolumesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListVolumesInput"}
	if s.GatewayARN != nil && len(*s.GatewayARN) < 50 {
		invalidParams.Add(aws.NewErrParamMinLen("GatewayARN", 50))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A JSON object containing the following fields:
//
//    * ListVolumesOutput$Marker
//
//    * ListVolumesOutput$VolumeInfos
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumesOutput
type ListVolumesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the gateway. Use the ListGateways operation
	// to return a list of gateways for your account and region.
	GatewayARN *string `min:"50" type:"string"`

	// Use the marker in your next request to continue pagination of iSCSI volumes.
	// If there are no more volumes to list, this field does not appear in the response
	// body.
	Marker *string `min:"1" type:"string"`

	// An array of VolumeInfo objects, where each object describes an iSCSI volume.
	// If no volumes are defined for the gateway, then VolumeInfos is an empty array
	// "[]".
	VolumeInfos []VolumeInfo `type:"list"`
}

// String returns the string representation
func (s ListVolumesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListVolumes = "ListVolumes"

// ListVolumesRequest returns a request value for making API operation for
// AWS Storage Gateway.
//
// Lists the iSCSI stored volumes of a gateway. Results are sorted by volume
// ARN. The response includes only the volume ARNs. If you want additional volume
// information, use the DescribeStorediSCSIVolumes or the DescribeCachediSCSIVolumes
// API.
//
// The operation supports pagination. By default, the operation returns a maximum
// of up to 100 volumes. You can optionally specify the Limit field in the body
// to limit the number of volumes in the response. If the number of volumes
// returned in the response is truncated, the response includes a Marker field.
// You can use this Marker value in your subsequent request to retrieve the
// next set of volumes. This operation is only supported in the cached volume
// and stored volume gateway types.
//
//    // Example sending a request using ListVolumesRequest.
//    req := client.ListVolumesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/storagegateway-2013-06-30/ListVolumes
func (c *Client) ListVolumesRequest(input *ListVolumesInput) ListVolumesRequest {
	op := &aws.Operation{
		Name:       opListVolumes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVolumesInput{}
	}

	req := c.newRequest(op, input, &ListVolumesOutput{})
	return ListVolumesRequest{Request: req, Input: input, Copy: c.ListVolumesRequest}
}

// ListVolumesRequest is the request type for the
// ListVolumes API operation.
type ListVolumesRequest struct {
	*aws.Request
	Input *ListVolumesInput
	Copy  func(*ListVolumesInput) ListVolumesRequest
}

// Send marshals and sends the ListVolumes API request.
func (r ListVolumesRequest) Send(ctx context.Context) (*ListVolumesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListVolumesResponse{
		ListVolumesOutput: r.Request.Data.(*ListVolumesOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListVolumesRequestPaginator returns a paginator for ListVolumes.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListVolumesRequest(input)
//   p := storagegateway.NewListVolumesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListVolumesPaginator(req ListVolumesRequest) ListVolumesPaginator {
	return ListVolumesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListVolumesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListVolumesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListVolumesPaginator struct {
	aws.Pager
}

func (p *ListVolumesPaginator) CurrentPage() *ListVolumesOutput {
	return p.Pager.CurrentPage().(*ListVolumesOutput)
}

// ListVolumesResponse is the response type for the
// ListVolumes API operation.
type ListVolumesResponse struct {
	*ListVolumesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListVolumes request.
func (r *ListVolumesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
