// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSessionRequest
type StartSessionInput struct {
	_ struct{} `type:"structure"`

	// The name of the SSM document to define the parameters and plugin settings
	// for the session. For example, SSM-SessionManagerRunShell. If no document
	// name is provided, a shell to the instance is launched by default.
	DocumentName *string `type:"string"`

	// Reserved for future use.
	Parameters map[string][]string `type:"map"`

	// The instance to connect to for the session.
	//
	// Target is a required field
	Target *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartSessionInput"}

	if s.Target == nil {
		invalidParams.Add(aws.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Target", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSessionResponse
type StartSessionOutput struct {
	_ struct{} `type:"structure"`

	// The ID of the session.
	SessionId *string `min:"1" type:"string"`

	// A URL back to SSM Agent on the instance that the Session Manager client uses
	// to send commands and receive output from the instance. Format: wss://ssm-messages.region.amazonaws.com/v1/data-channel/session-id?stream=(input|output)
	//
	// region represents the Region identifier for an AWS Region supported by AWS
	// Systems Manager, such as us-east-2 for the US East (Ohio) Region. For a list
	// of supported region values, see the Region column in the AWS Systems Manager
	// table of regions and endpoints (http://docs.aws.amazon.com/general/latest/gr/rande.html#ssm_region)
	// in the AWS General Reference.
	//
	// session-id represents the ID of a Session Manager session, such as 1a2b3c4dEXAMPLE.
	StreamUrl *string `type:"string"`

	// An encrypted token value containing session and caller information. Used
	// to authenticate the connection to the instance.
	TokenValue *string `type:"string"`
}

// String returns the string representation
func (s StartSessionOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartSession = "StartSession"

// StartSessionRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Initiates a connection to a target (for example, an instance) for a Session
// Manager session. Returns a URL and token that can be used to open a WebSocket
// connection for sending input and receiving outputs.
//
// AWS CLI usage: start-session is an interactive command that requires the
// Session Manager plugin to be installed on the client machine making the call.
// For information, see Install the Session Manager Plugin for the AWS CLI (http://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html)
// in the AWS Systems Manager User Guide.
//
//    // Example sending a request using StartSessionRequest.
//    req := client.StartSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSession
func (c *Client) StartSessionRequest(input *StartSessionInput) StartSessionRequest {
	op := &aws.Operation{
		Name:       opStartSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartSessionInput{}
	}

	req := c.newRequest(op, input, &StartSessionOutput{})
	return StartSessionRequest{Request: req, Input: input, Copy: c.StartSessionRequest}
}

// StartSessionRequest is the request type for the
// StartSession API operation.
type StartSessionRequest struct {
	*aws.Request
	Input *StartSessionInput
	Copy  func(*StartSessionInput) StartSessionRequest
}

// Send marshals and sends the StartSession API request.
func (r StartSessionRequest) Send(ctx context.Context) (*StartSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartSessionResponse{
		StartSessionOutput: r.Request.Data.(*StartSessionOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartSessionResponse is the response type for the
// StartSession API operation.
type StartSessionResponse struct {
	*StartSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartSession request.
func (r *StartSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
