// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandsRequest
type ListCommandsInput struct {
	_ struct{} `type:"structure"`

	// (Optional) If provided, lists only the specified command.
	CommandId *string `min:"36" type:"string"`

	// (Optional) One or more filters. Use a filter to return a more specific list
	// of results.
	Filters []CommandFilter `min:"1" type:"list"`

	// (Optional) Lists commands issued against this instance ID.
	InstanceId *string `type:"string"`

	// (Optional) The maximum number of items to return for this call. The call
	// also returns a token that you can specify in a subsequent call to get the
	// next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCommandsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListCommandsInput"}
	if s.CommandId != nil && len(*s.CommandId) < 36 {
		invalidParams.Add(aws.NewErrParamMinLen("CommandId", 36))
	}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Filters", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandsResult
type ListCommandsOutput struct {
	_ struct{} `type:"structure"`

	// (Optional) The list of commands requested by the user.
	Commands []Command `type:"list"`

	// (Optional) The token for the next set of items to return. (You received this
	// token from a previous call.)
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListCommandsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListCommands = "ListCommands"

// ListCommandsRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Lists the commands requested by users of the AWS account.
//
//    // Example sending a request using ListCommandsRequest.
//    req := client.ListCommandsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands
func (c *Client) ListCommandsRequest(input *ListCommandsInput) ListCommandsRequest {
	op := &aws.Operation{
		Name:       opListCommands,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCommandsInput{}
	}

	req := c.newRequest(op, input, &ListCommandsOutput{})
	return ListCommandsRequest{Request: req, Input: input, Copy: c.ListCommandsRequest}
}

// ListCommandsRequest is the request type for the
// ListCommands API operation.
type ListCommandsRequest struct {
	*aws.Request
	Input *ListCommandsInput
	Copy  func(*ListCommandsInput) ListCommandsRequest
}

// Send marshals and sends the ListCommands API request.
func (r ListCommandsRequest) Send(ctx context.Context) (*ListCommandsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListCommandsResponse{
		ListCommandsOutput: r.Request.Data.(*ListCommandsOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListCommandsRequestPaginator returns a paginator for ListCommands.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListCommandsRequest(input)
//   p := ssm.NewListCommandsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListCommandsPaginator(req ListCommandsRequest) ListCommandsPaginator {
	return ListCommandsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListCommandsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListCommandsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListCommandsPaginator struct {
	aws.Pager
}

func (p *ListCommandsPaginator) CurrentPage() *ListCommandsOutput {
	return p.Pager.CurrentPage().(*ListCommandsOutput)
}

// ListCommandsResponse is the response type for the
// ListCommands API operation.
type ListCommandsResponse struct {
	*ListCommandsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListCommands request.
func (r *ListCommandsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
