// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The request body of the GetServiceSetting API action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSettingRequest
type GetServiceSettingInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service setting to get.
	//
	// SettingId is a required field
	SettingId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetServiceSettingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceSettingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetServiceSettingInput"}

	if s.SettingId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SettingId"))
	}
	if s.SettingId != nil && len(*s.SettingId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SettingId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The query result body of the GetServiceSetting API action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSettingResult
type GetServiceSettingOutput struct {
	_ struct{} `type:"structure"`

	// The query result of the current service setting.
	ServiceSetting *ServiceSetting `type:"structure"`
}

// String returns the string representation
func (s GetServiceSettingOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetServiceSetting = "GetServiceSetting"

// GetServiceSettingRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// ServiceSetting is an account-level setting for an AWS service. This setting
// defines how a user interacts with or uses a service or a feature of a service.
// For example, if an AWS service charges money to the account based on feature
// or service usage, then the AWS service team might create a default setting
// of "false". This means the user can't use this feature unless they change
// the setting to "true" and intentionally opt in for a paid feature.
//
// Services map a SettingId object to a setting value. AWS services teams define
// the default value for a SettingId. You can't create a new SettingId, but
// you can overwrite the default value if you have the ssm:UpdateServiceSetting
// permission for the setting. Use the UpdateServiceSetting API action to change
// the default setting. Or use the ResetServiceSetting to change the value back
// to the original value defined by the AWS service team.
//
// Query the current service setting for the account.
//
//    // Example sending a request using GetServiceSettingRequest.
//    req := client.GetServiceSettingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting
func (c *Client) GetServiceSettingRequest(input *GetServiceSettingInput) GetServiceSettingRequest {
	op := &aws.Operation{
		Name:       opGetServiceSetting,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceSettingInput{}
	}

	req := c.newRequest(op, input, &GetServiceSettingOutput{})
	return GetServiceSettingRequest{Request: req, Input: input, Copy: c.GetServiceSettingRequest}
}

// GetServiceSettingRequest is the request type for the
// GetServiceSetting API operation.
type GetServiceSettingRequest struct {
	*aws.Request
	Input *GetServiceSettingInput
	Copy  func(*GetServiceSettingInput) GetServiceSettingRequest
}

// Send marshals and sends the GetServiceSetting API request.
func (r GetServiceSettingRequest) Send(ctx context.Context) (*GetServiceSettingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetServiceSettingResponse{
		GetServiceSettingOutput: r.Request.Data.(*GetServiceSettingOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetServiceSettingResponse is the response type for the
// GetServiceSetting API operation.
type GetServiceSettingResponse struct {
	*GetServiceSettingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetServiceSetting request.
func (r *GetServiceSettingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
