// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package shield

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtectionRequest
type DescribeProtectionInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier (ID) for the Protection object that is described. When
	// submitting the DescribeProtection request you must provide either the ResourceArn
	// or the ProtectionID, but not both.
	ProtectionId *string `min:"1" type:"string"`

	// The ARN (Amazon Resource Name) of the AWS resource for the Protection object
	// that is described. When submitting the DescribeProtection request you must
	// provide either the ResourceArn or the ProtectionID, but not both.
	ResourceArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProtectionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeProtectionInput"}
	if s.ProtectionId != nil && len(*s.ProtectionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProtectionId", 1))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtectionResponse
type DescribeProtectionOutput struct {
	_ struct{} `type:"structure"`

	// The Protection object that is described.
	Protection *Protection `type:"structure"`
}

// String returns the string representation
func (s DescribeProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeProtection = "DescribeProtection"

// DescribeProtectionRequest returns a request value for making API operation for
// AWS Shield.
//
// Lists the details of a Protection object.
//
//    // Example sending a request using DescribeProtectionRequest.
//    req := client.DescribeProtectionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeProtection
func (c *Client) DescribeProtectionRequest(input *DescribeProtectionInput) DescribeProtectionRequest {
	op := &aws.Operation{
		Name:       opDescribeProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeProtectionInput{}
	}

	req := c.newRequest(op, input, &DescribeProtectionOutput{})
	return DescribeProtectionRequest{Request: req, Input: input, Copy: c.DescribeProtectionRequest}
}

// DescribeProtectionRequest is the request type for the
// DescribeProtection API operation.
type DescribeProtectionRequest struct {
	*aws.Request
	Input *DescribeProtectionInput
	Copy  func(*DescribeProtectionInput) DescribeProtectionRequest
}

// Send marshals and sends the DescribeProtection API request.
func (r DescribeProtectionRequest) Send(ctx context.Context) (*DescribeProtectionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeProtectionResponse{
		DescribeProtectionOutput: r.Request.Data.(*DescribeProtectionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeProtectionResponse is the response type for the
// DescribeProtection API operation.
type DescribeProtectionResponse struct {
	*DescribeProtectionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeProtection request.
func (r *DescribeProtectionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
