// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sfn

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecutionInput
type StopExecutionInput struct {
	_ struct{} `type:"structure"`

	// A more detailed explanation of the cause of the failure.
	Cause *string `locationName:"cause" type:"string"`

	// The error code of the failure.
	Error *string `locationName:"error" type:"string"`

	// The Amazon Resource Name (ARN) of the execution to stop.
	//
	// ExecutionArn is a required field
	ExecutionArn *string `locationName:"executionArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopExecutionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopExecutionInput"}

	if s.ExecutionArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExecutionArn"))
	}
	if s.ExecutionArn != nil && len(*s.ExecutionArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ExecutionArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecutionOutput
type StopExecutionOutput struct {
	_ struct{} `type:"structure"`

	// The date the execution is stopped.
	//
	// StopDate is a required field
	StopDate *time.Time `locationName:"stopDate" type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s StopExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopExecution = "StopExecution"

// StopExecutionRequest returns a request value for making API operation for
// AWS Step Functions.
//
// Stops an execution.
//
//    // Example sending a request using StopExecutionRequest.
//    req := client.StopExecutionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/states-2016-11-23/StopExecution
func (c *Client) StopExecutionRequest(input *StopExecutionInput) StopExecutionRequest {
	op := &aws.Operation{
		Name:       opStopExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopExecutionInput{}
	}

	req := c.newRequest(op, input, &StopExecutionOutput{})
	return StopExecutionRequest{Request: req, Input: input, Copy: c.StopExecutionRequest}
}

// StopExecutionRequest is the request type for the
// StopExecution API operation.
type StopExecutionRequest struct {
	*aws.Request
	Input *StopExecutionInput
	Copy  func(*StopExecutionInput) StopExecutionRequest
}

// Send marshals and sends the StopExecution API request.
func (r StopExecutionRequest) Send(ctx context.Context) (*StopExecutionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopExecutionResponse{
		StopExecutionOutput: r.Request.Data.(*StopExecutionOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopExecutionResponse is the response type for the
// StopExecution API operation.
type StopExecutionResponse struct {
	*StopExecutionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopExecution request.
func (r *StopExecutionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
