// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductInput
type UpdateProvisionedProductInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The new path identifier. This value is optional if the product has a default
	// path, and required if the product has more than one path.
	PathId *string `min:"1" type:"string"`

	// The identifier of the product.
	ProductId *string `min:"1" type:"string"`

	// The identifier of the provisioned product. You cannot specify both ProvisionedProductName
	// and ProvisionedProductId.
	ProvisionedProductId *string `min:"1" type:"string"`

	// The name of the provisioned product. You cannot specify both ProvisionedProductName
	// and ProvisionedProductId.
	ProvisionedProductName *string `min:"1" type:"string"`

	// The identifier of the provisioning artifact.
	ProvisioningArtifactId *string `min:"1" type:"string"`

	// The new parameters.
	ProvisioningParameters []UpdateProvisioningParameter `type:"list"`

	// An object that contains information about the provisioning preferences for
	// a stack set.
	ProvisioningPreferences *UpdateProvisioningPreferences `type:"structure"`

	// One or more tags. Requires the product to have RESOURCE_UPDATE constraint
	// with TagUpdatesOnProvisionedProduct set to ALLOWED to allow tag updates.
	Tags []Tag `type:"list"`

	// The idempotency token that uniquely identifies the provisioning update request.
	//
	// UpdateToken is a required field
	UpdateToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`
}

// String returns the string representation
func (s UpdateProvisionedProductInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProvisionedProductInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateProvisionedProductInput"}
	if s.PathId != nil && len(*s.PathId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PathId", 1))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}
	if s.ProvisionedProductId != nil && len(*s.ProvisionedProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisionedProductId", 1))
	}
	if s.ProvisionedProductName != nil && len(*s.ProvisionedProductName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisionedProductName", 1))
	}
	if s.ProvisioningArtifactId != nil && len(*s.ProvisioningArtifactId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProvisioningArtifactId", 1))
	}

	if s.UpdateToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdateToken"))
	}
	if s.UpdateToken != nil && len(*s.UpdateToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UpdateToken", 1))
	}
	if s.ProvisioningParameters != nil {
		for i, v := range s.ProvisioningParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProvisioningParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ProvisioningPreferences != nil {
		if err := s.ProvisioningPreferences.Validate(); err != nil {
			invalidParams.AddNested("ProvisioningPreferences", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProductOutput
type UpdateProvisionedProductOutput struct {
	_ struct{} `type:"structure"`

	// Information about the result of the request.
	RecordDetail *RecordDetail `type:"structure"`
}

// String returns the string representation
func (s UpdateProvisionedProductOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateProvisionedProduct = "UpdateProvisionedProduct"

// UpdateProvisionedProductRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Requests updates to the configuration of the specified provisioned product.
//
// If there are tags associated with the object, they cannot be updated or added.
// Depending on the specific updates requested, this operation can update with
// no interruption, with some interruption, or replace the provisioned product
// entirely.
//
// You can check the status of this request using DescribeRecord.
//
//    // Example sending a request using UpdateProvisionedProductRequest.
//    req := client.UpdateProvisionedProductRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/UpdateProvisionedProduct
func (c *Client) UpdateProvisionedProductRequest(input *UpdateProvisionedProductInput) UpdateProvisionedProductRequest {
	op := &aws.Operation{
		Name:       opUpdateProvisionedProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateProvisionedProductInput{}
	}

	req := c.newRequest(op, input, &UpdateProvisionedProductOutput{})
	return UpdateProvisionedProductRequest{Request: req, Input: input, Copy: c.UpdateProvisionedProductRequest}
}

// UpdateProvisionedProductRequest is the request type for the
// UpdateProvisionedProduct API operation.
type UpdateProvisionedProductRequest struct {
	*aws.Request
	Input *UpdateProvisionedProductInput
	Copy  func(*UpdateProvisionedProductInput) UpdateProvisionedProductRequest
}

// Send marshals and sends the UpdateProvisionedProduct API request.
func (r UpdateProvisionedProductRequest) Send(ctx context.Context) (*UpdateProvisionedProductResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateProvisionedProductResponse{
		UpdateProvisionedProductOutput: r.Request.Data.(*UpdateProvisionedProductOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateProvisionedProductResponse is the response type for the
// UpdateProvisionedProduct API operation.
type UpdateProvisionedProductResponse struct {
	*UpdateProvisionedProductOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateProvisionedProduct request.
func (r *UpdateProvisionedProductResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
