// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProductsInput
type SearchProvisionedProductsInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The access level to use to obtain results. The default is User.
	AccessLevelFilter *AccessLevelFilter `type:"structure"`

	// The search filters.
	//
	// When the key is SearchQuery, the searchable fields are arn, createdTime,
	// id, lastRecordId, idempotencyToken, name, physicalId, productId, provisioningArtifact,
	// type, status, tags, userArn, and userArnSession.
	//
	// Example: "SearchQuery":["status:AVAILABLE"]
	Filters map[string][]string `type:"map"`

	// The maximum number of items to return with this call.
	PageSize *int64 `type:"integer"`

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string `type:"string"`

	// The sort field. If no value is specified, the results are not sorted. The
	// valid values are arn, id, name, and lastRecordId.
	SortBy *string `type:"string"`

	// The sort order. If no value is specified, the results are not sorted.
	SortOrder SortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s SearchProvisionedProductsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProductsOutput
type SearchProvisionedProductsOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`

	// Information about the provisioned products.
	ProvisionedProducts []ProvisionedProductAttribute `type:"list"`

	// The number of provisioned products found.
	TotalResultsCount *int64 `type:"integer"`
}

// String returns the string representation
func (s SearchProvisionedProductsOutput) String() string {
	return awsutil.Prettify(s)
}

const opSearchProvisionedProducts = "SearchProvisionedProducts"

// SearchProvisionedProductsRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Gets information about the provisioned products that meet the specified criteria.
//
//    // Example sending a request using SearchProvisionedProductsRequest.
//    req := client.SearchProvisionedProductsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/SearchProvisionedProducts
func (c *Client) SearchProvisionedProductsRequest(input *SearchProvisionedProductsInput) SearchProvisionedProductsRequest {
	op := &aws.Operation{
		Name:       opSearchProvisionedProducts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchProvisionedProductsInput{}
	}

	req := c.newRequest(op, input, &SearchProvisionedProductsOutput{})
	return SearchProvisionedProductsRequest{Request: req, Input: input, Copy: c.SearchProvisionedProductsRequest}
}

// SearchProvisionedProductsRequest is the request type for the
// SearchProvisionedProducts API operation.
type SearchProvisionedProductsRequest struct {
	*aws.Request
	Input *SearchProvisionedProductsInput
	Copy  func(*SearchProvisionedProductsInput) SearchProvisionedProductsRequest
}

// Send marshals and sends the SearchProvisionedProducts API request.
func (r SearchProvisionedProductsRequest) Send(ctx context.Context) (*SearchProvisionedProductsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SearchProvisionedProductsResponse{
		SearchProvisionedProductsOutput: r.Request.Data.(*SearchProvisionedProductsOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewSearchProvisionedProductsRequestPaginator returns a paginator for SearchProvisionedProducts.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.SearchProvisionedProductsRequest(input)
//   p := servicecatalog.NewSearchProvisionedProductsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewSearchProvisionedProductsPaginator(req SearchProvisionedProductsRequest) SearchProvisionedProductsPaginator {
	return SearchProvisionedProductsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *SearchProvisionedProductsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// SearchProvisionedProductsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type SearchProvisionedProductsPaginator struct {
	aws.Pager
}

func (p *SearchProvisionedProductsPaginator) CurrentPage() *SearchProvisionedProductsOutput {
	return p.Pager.CurrentPage().(*SearchProvisionedProductsOutput)
}

// SearchProvisionedProductsResponse is the response type for the
// SearchProvisionedProducts API operation.
type SearchProvisionedProductsResponse struct {
	*SearchProvisionedProductsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SearchProvisionedProducts request.
func (r *SearchProvisionedProductsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
