// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProductInput
type ListPortfoliosForProductInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The maximum number of items to return with this call.
	PageSize *int64 `type:"integer"`

	// The page token for the next set of results. To retrieve the first set of
	// results, use null.
	PageToken *string `type:"string"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListPortfoliosForProductInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPortfoliosForProductInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPortfoliosForProductInput"}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProductOutput
type ListPortfoliosForProductOutput struct {
	_ struct{} `type:"structure"`

	// The page token to use to retrieve the next set of results. If there are no
	// additional results, this value is null.
	NextPageToken *string `type:"string"`

	// Information about the portfolios.
	PortfolioDetails []PortfolioDetail `type:"list"`
}

// String returns the string representation
func (s ListPortfoliosForProductOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPortfoliosForProduct = "ListPortfoliosForProduct"

// ListPortfoliosForProductRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Lists all portfolios that the specified product is associated with.
//
//    // Example sending a request using ListPortfoliosForProductRequest.
//    req := client.ListPortfoliosForProductRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/ListPortfoliosForProduct
func (c *Client) ListPortfoliosForProductRequest(input *ListPortfoliosForProductInput) ListPortfoliosForProductRequest {
	op := &aws.Operation{
		Name:       opListPortfoliosForProduct,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"PageToken"},
			OutputTokens:    []string{"NextPageToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPortfoliosForProductInput{}
	}

	req := c.newRequest(op, input, &ListPortfoliosForProductOutput{})
	return ListPortfoliosForProductRequest{Request: req, Input: input, Copy: c.ListPortfoliosForProductRequest}
}

// ListPortfoliosForProductRequest is the request type for the
// ListPortfoliosForProduct API operation.
type ListPortfoliosForProductRequest struct {
	*aws.Request
	Input *ListPortfoliosForProductInput
	Copy  func(*ListPortfoliosForProductInput) ListPortfoliosForProductRequest
}

// Send marshals and sends the ListPortfoliosForProduct API request.
func (r ListPortfoliosForProductRequest) Send(ctx context.Context) (*ListPortfoliosForProductResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPortfoliosForProductResponse{
		ListPortfoliosForProductOutput: r.Request.Data.(*ListPortfoliosForProductOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPortfoliosForProductRequestPaginator returns a paginator for ListPortfoliosForProduct.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPortfoliosForProductRequest(input)
//   p := servicecatalog.NewListPortfoliosForProductRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPortfoliosForProductPaginator(req ListPortfoliosForProductRequest) ListPortfoliosForProductPaginator {
	return ListPortfoliosForProductPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPortfoliosForProductInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPortfoliosForProductPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPortfoliosForProductPaginator struct {
	aws.Pager
}

func (p *ListPortfoliosForProductPaginator) CurrentPage() *ListPortfoliosForProductOutput {
	return p.Pager.CurrentPage().(*ListPortfoliosForProductOutput)
}

// ListPortfoliosForProductResponse is the response type for the
// ListPortfoliosForProduct API operation.
type ListPortfoliosForProductResponse struct {
	*ListPortfoliosForProductOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPortfoliosForProduct request.
func (r *ListPortfoliosForProductResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
