// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolioInput
type AssociateProductWithPortfolioInput struct {
	_ struct{} `type:"structure"`

	// The language code.
	//
	//    * en - English (default)
	//
	//    * jp - Japanese
	//
	//    * zh - Chinese
	AcceptLanguage *string `type:"string"`

	// The portfolio identifier.
	//
	// PortfolioId is a required field
	PortfolioId *string `min:"1" type:"string" required:"true"`

	// The product identifier.
	//
	// ProductId is a required field
	ProductId *string `min:"1" type:"string" required:"true"`

	// The identifier of the source portfolio.
	SourcePortfolioId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AssociateProductWithPortfolioInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateProductWithPortfolioInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateProductWithPortfolioInput"}

	if s.PortfolioId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortfolioId"))
	}
	if s.PortfolioId != nil && len(*s.PortfolioId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PortfolioId", 1))
	}

	if s.ProductId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductId", 1))
	}
	if s.SourcePortfolioId != nil && len(*s.SourcePortfolioId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourcePortfolioId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolioOutput
type AssociateProductWithPortfolioOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateProductWithPortfolioOutput) String() string {
	return awsutil.Prettify(s)
}

const opAssociateProductWithPortfolio = "AssociateProductWithPortfolio"

// AssociateProductWithPortfolioRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Associates the specified product with the specified portfolio.
//
//    // Example sending a request using AssociateProductWithPortfolioRequest.
//    req := client.AssociateProductWithPortfolioRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/AssociateProductWithPortfolio
func (c *Client) AssociateProductWithPortfolioRequest(input *AssociateProductWithPortfolioInput) AssociateProductWithPortfolioRequest {
	op := &aws.Operation{
		Name:       opAssociateProductWithPortfolio,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateProductWithPortfolioInput{}
	}

	req := c.newRequest(op, input, &AssociateProductWithPortfolioOutput{})
	return AssociateProductWithPortfolioRequest{Request: req, Input: input, Copy: c.AssociateProductWithPortfolioRequest}
}

// AssociateProductWithPortfolioRequest is the request type for the
// AssociateProductWithPortfolio API operation.
type AssociateProductWithPortfolioRequest struct {
	*aws.Request
	Input *AssociateProductWithPortfolioInput
	Copy  func(*AssociateProductWithPortfolioInput) AssociateProductWithPortfolioRequest
}

// Send marshals and sends the AssociateProductWithPortfolio API request.
func (r AssociateProductWithPortfolioRequest) Send(ctx context.Context) (*AssociateProductWithPortfolioResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateProductWithPortfolioResponse{
		AssociateProductWithPortfolioOutput: r.Request.Data.(*AssociateProductWithPortfolioOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateProductWithPortfolioResponse is the response type for the
// AssociateProductWithPortfolio API operation.
type AssociateProductWithPortfolioResponse struct {
	*AssociateProductWithPortfolioOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateProductWithPortfolio request.
func (r *AssociateProductWithPortfolioResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
