// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package secretsmanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStageRequest
type UpdateSecretVersionStageInput struct {
	_ struct{} `type:"structure"`

	// (Optional) The secret version ID that you want to add the staging label to.
	// If you want to remove a label from a version, then do not specify this parameter.
	//
	// If the staging label is already attached to a different version of the secret,
	// then you must also specify the RemoveFromVersionId parameter.
	MoveToVersionId *string `min:"32" type:"string"`

	// Specifies the secret version ID of the version that the staging label is
	// to be removed from. If the staging label you are trying to attach to one
	// version is already attached to a different version, then you must include
	// this parameter and specify the version that the label is to be removed from.
	// If the label is attached and you either do not specify this parameter, or
	// the version ID does not match, then the operation fails.
	RemoveFromVersionId *string `min:"32" type:"string"`

	// Specifies the secret with the version whose list of staging labels you want
	// to modify. You can specify either the Amazon Resource Name (ARN) or the friendly
	// name of the secret.
	//
	// If you specify an ARN, we generally recommend that you specify a complete
	// ARN. You can specify a partial ARN too—for example, if you don’t include
	// the final hyphen and six random characters that Secrets Manager adds at the
	// end of the ARN when you created the secret. A partial ARN match can work
	// as long as it uniquely matches only one secret. However, if your secret has
	// a name that ends in a hyphen followed by six characters (before Secrets Manager
	// adds the hyphen and six characters to the ARN) and you try to use that as
	// a partial ARN, then those characters cause Secrets Manager to assume that
	// you’re specifying a complete ARN. This confusion can cause unexpected results.
	// To avoid this situation, we recommend that you don’t create secret names
	// that end with a hyphen followed by six characters.
	//
	// SecretId is a required field
	SecretId *string `min:"1" type:"string" required:"true"`

	// The staging label to add to this version.
	//
	// VersionStage is a required field
	VersionStage *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateSecretVersionStageInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSecretVersionStageInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSecretVersionStageInput"}
	if s.MoveToVersionId != nil && len(*s.MoveToVersionId) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("MoveToVersionId", 32))
	}
	if s.RemoveFromVersionId != nil && len(*s.RemoveFromVersionId) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("RemoveFromVersionId", 32))
	}

	if s.SecretId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SecretId"))
	}
	if s.SecretId != nil && len(*s.SecretId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SecretId", 1))
	}

	if s.VersionStage == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionStage"))
	}
	if s.VersionStage != nil && len(*s.VersionStage) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("VersionStage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStageResponse
type UpdateSecretVersionStageOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the secret with the staging label that was modified.
	ARN *string `min:"20" type:"string"`

	// The friendly name of the secret with the staging label that was modified.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSecretVersionStageOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateSecretVersionStage = "UpdateSecretVersionStage"

// UpdateSecretVersionStageRequest returns a request value for making API operation for
// AWS Secrets Manager.
//
// Modifies the staging labels attached to a version of a secret. Staging labels
// are used to track a version as it progresses through the secret rotation
// process. You can attach a staging label to only one version of a secret at
// a time. If a staging label to be added is already attached to another version,
// then it is moved--removed from the other version first and then attached
// to this one. For more information about staging labels, see Staging Labels
// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/terms-concepts.html#term_staging-label)
// in the AWS Secrets Manager User Guide.
//
// The staging labels that you specify in the VersionStage parameter are added
// to the existing list of staging labels--they don't replace it.
//
// You can move the AWSCURRENT staging label to this version by including it
// in this call.
//
// Whenever you move AWSCURRENT, Secrets Manager automatically moves the label
// AWSPREVIOUS to the version that AWSCURRENT was removed from.
//
// If this action results in the last label being removed from a version, then
// the version is considered to be 'deprecated' and can be deleted by Secrets
// Manager.
//
// Minimum permissions
//
// To run this command, you must have the following permissions:
//
//    * secretsmanager:UpdateSecretVersionStage
//
// Related operations
//
//    * To get the list of staging labels that are currently associated with
//    a version of a secret, use DescribeSecret and examine the SecretVersionsToStages
//    response value.
//
//    // Example sending a request using UpdateSecretVersionStageRequest.
//    req := client.UpdateSecretVersionStageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/secretsmanager-2017-10-17/UpdateSecretVersionStage
func (c *Client) UpdateSecretVersionStageRequest(input *UpdateSecretVersionStageInput) UpdateSecretVersionStageRequest {
	op := &aws.Operation{
		Name:       opUpdateSecretVersionStage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSecretVersionStageInput{}
	}

	req := c.newRequest(op, input, &UpdateSecretVersionStageOutput{})
	return UpdateSecretVersionStageRequest{Request: req, Input: input, Copy: c.UpdateSecretVersionStageRequest}
}

// UpdateSecretVersionStageRequest is the request type for the
// UpdateSecretVersionStage API operation.
type UpdateSecretVersionStageRequest struct {
	*aws.Request
	Input *UpdateSecretVersionStageInput
	Copy  func(*UpdateSecretVersionStageInput) UpdateSecretVersionStageRequest
}

// Send marshals and sends the UpdateSecretVersionStage API request.
func (r UpdateSecretVersionStageRequest) Send(ctx context.Context) (*UpdateSecretVersionStageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSecretVersionStageResponse{
		UpdateSecretVersionStageOutput: r.Request.Data.(*UpdateSecretVersionStageOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSecretVersionStageResponse is the response type for the
// UpdateSecretVersionStage API operation.
type UpdateSecretVersionStageResponse struct {
	*UpdateSecretVersionStageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSecretVersionStage request.
func (r *UpdateSecretVersionStageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
