// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfigInput
type CreateEndpointConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of the endpoint configuration. You specify this name in a CreateEndpoint
	// (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html)
	// request.
	//
	// EndpointConfigName is a required field
	EndpointConfigName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of a AWS Key Management Service key that Amazon
	// SageMaker uses to encrypt data on the storage volume attached to the ML compute
	// instance that hosts the endpoint.
	KmsKeyId *string `type:"string"`

	// An list of ProductionVariant objects, one for each model that you want to
	// host at this endpoint.
	//
	// ProductionVariants is a required field
	ProductionVariants []ProductionVariant `min:"1" type:"list" required:"true"`

	// A list of key-value pairs. For more information, see Using Cost Allocation
	// Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
	// in the AWS Billing and Cost Management User Guide.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateEndpointConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEndpointConfigInput"}

	if s.EndpointConfigName == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointConfigName"))
	}

	if s.ProductionVariants == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductionVariants"))
	}
	if s.ProductionVariants != nil && len(s.ProductionVariants) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProductionVariants", 1))
	}
	if s.ProductionVariants != nil {
		for i, v := range s.ProductionVariants {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ProductionVariants", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfigOutput
type CreateEndpointConfigOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the endpoint configuration.
	//
	// EndpointConfigArn is a required field
	EndpointConfigArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEndpointConfigOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEndpointConfig = "CreateEndpointConfig"

// CreateEndpointConfigRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Creates an endpoint configuration that Amazon SageMaker hosting services
// uses to deploy models. In the configuration, you identify one or more models,
// created using the CreateModel API, to deploy and the resources that you want
// Amazon SageMaker to provision. Then you call the CreateEndpoint (https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html)
// API.
//
// Use this API only if you want to use Amazon SageMaker hosting services to
// deploy models into production.
//
// In the request, you define one or more ProductionVariants, each of which
// identifies a model. Each ProductionVariant parameter also describes the resources
// that you want Amazon SageMaker to provision. This includes the number and
// type of ML compute instances to deploy.
//
// If you are hosting multiple models, you also assign a VariantWeight to specify
// how much traffic you want to allocate to each model. For example, suppose
// that you want to host two models, A and B, and you assign traffic weight
// 2 for model A and 1 for model B. Amazon SageMaker distributes two-thirds
// of the traffic to Model A, and one-third to model B.
//
//    // Example sending a request using CreateEndpointConfigRequest.
//    req := client.CreateEndpointConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/CreateEndpointConfig
func (c *Client) CreateEndpointConfigRequest(input *CreateEndpointConfigInput) CreateEndpointConfigRequest {
	op := &aws.Operation{
		Name:       opCreateEndpointConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointConfigInput{}
	}

	req := c.newRequest(op, input, &CreateEndpointConfigOutput{})
	return CreateEndpointConfigRequest{Request: req, Input: input, Copy: c.CreateEndpointConfigRequest}
}

// CreateEndpointConfigRequest is the request type for the
// CreateEndpointConfig API operation.
type CreateEndpointConfigRequest struct {
	*aws.Request
	Input *CreateEndpointConfigInput
	Copy  func(*CreateEndpointConfigInput) CreateEndpointConfigRequest
}

// Send marshals and sends the CreateEndpointConfig API request.
func (r CreateEndpointConfigRequest) Send(ctx context.Context) (*CreateEndpointConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEndpointConfigResponse{
		CreateEndpointConfigOutput: r.Request.Data.(*CreateEndpointConfigOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEndpointConfigResponse is the response type for the
// CreateEndpointConfig API operation.
type CreateEndpointConfigResponse struct {
	*CreateEndpointConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEndpointConfig request.
func (r *CreateEndpointConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
