// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3control

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJobRequest
type DescribeJobInput struct {
	_ struct{} `type:"structure"`

	// AccountId is a required field
	AccountId *string `location:"header" locationName:"x-amz-account-id" type:"string" required:"true"`

	// The ID for the job whose information you want to retrieve.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"id" min:"5" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeJobInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeJobInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-account-id", protocol.StringValue(v), metadata)
	}
	if s.JobId != nil {
		v := *s.JobId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "id", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJobResult
type DescribeJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains the configuration parameters and status for the job specified in
	// the Describe Job request.
	Job *JobDescriptor `type:"structure"`
}

// String returns the string representation
func (s DescribeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DescribeJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Job != nil {
		v := s.Job

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Job", v, metadata)
	}
	return nil
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest returns a request value for making API operation for
// AWS S3 Control.
//
// Retrieves the configuration parameters and status for a batch operations
// job.
//
//    // Example sending a request using DescribeJobRequest.
//    req := client.DescribeJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/DescribeJob
func (c *Client) DescribeJobRequest(input *DescribeJobInput) DescribeJobRequest {
	op := &aws.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/v20180820/jobs/{id}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	req := c.newRequest(op, input, &DescribeJobOutput{})
	req.Handlers.Build.PushBackNamed(buildPrefixHostHandler("AccountID", aws.StringValue(input.AccountId)))
	req.Handlers.Build.PushBackNamed(buildRemoveHeaderHandler("X-Amz-Account-Id"))
	return DescribeJobRequest{Request: req, Input: input, Copy: c.DescribeJobRequest}
}

// DescribeJobRequest is the request type for the
// DescribeJob API operation.
type DescribeJobRequest struct {
	*aws.Request
	Input *DescribeJobInput
	Copy  func(*DescribeJobInput) DescribeJobRequest
}

// Send marshals and sends the DescribeJob API request.
func (r DescribeJobRequest) Send(ctx context.Context) (*DescribeJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeJobResponse{
		DescribeJobOutput: r.Request.Data.(*DescribeJobOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeJobResponse is the response type for the
// DescribeJob API operation.
type DescribeJobResponse struct {
	*DescribeJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeJob request.
func (r *DescribeJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
