// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObjectRequest
type RestoreObjectInput struct {
	_ struct{} `type:"structure" payload:"RestoreRequest"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Confirms that the requester knows that she or he will be charged for the
	// request. Bucket owners need not specify this parameter in their requests.
	// Documentation on downloading objects from requester pays buckets can be found
	// at http://docs.aws.amazon.com/AmazonS3/latest/dev/ObjectsinRequesterPaysBuckets.html
	RequestPayer RequestPayer `location:"header" locationName:"x-amz-request-payer" type:"string" enum:"true"`

	// Container for restore job parameters.
	RestoreRequest *RestoreRequest `locationName:"RestoreRequest" type:"structure" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s RestoreObjectInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreObjectInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RestoreObjectInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.RestoreRequest != nil {
		if err := s.RestoreRequest.Validate(); err != nil {
			invalidParams.AddNested("RestoreRequest", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *RestoreObjectInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreObjectInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.RequestPayer) > 0 {
		v := s.RequestPayer

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-payer", v, metadata)
	}
	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.RestoreRequest != nil {
		v := s.RestoreRequest

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "RestoreRequest", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObjectOutput
type RestoreObjectOutput struct {
	_ struct{} `type:"structure"`

	// If present, indicates that the requester was successfully charged for the
	// request.
	RequestCharged RequestCharged `location:"header" locationName:"x-amz-request-charged" type:"string" enum:"true"`

	// Indicates the path in the provided S3 output location where Select results
	// will be restored to.
	RestoreOutputPath *string `location:"header" locationName:"x-amz-restore-output-path" type:"string"`
}

// String returns the string representation
func (s RestoreObjectOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RestoreObjectOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.RequestCharged) > 0 {
		v := s.RequestCharged

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-request-charged", v, metadata)
	}
	if s.RestoreOutputPath != nil {
		v := *s.RestoreOutputPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-restore-output-path", protocol.StringValue(v), metadata)
	}
	return nil
}

const opRestoreObject = "RestoreObject"

// RestoreObjectRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Restores an archived copy of an object back into Amazon S3
//
//    // Example sending a request using RestoreObjectRequest.
//    req := client.RestoreObjectRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/RestoreObject
func (c *Client) RestoreObjectRequest(input *RestoreObjectInput) RestoreObjectRequest {
	op := &aws.Operation{
		Name:       opRestoreObject,
		HTTPMethod: "POST",
		HTTPPath:   "/{Bucket}/{Key+}?restore",
	}

	if input == nil {
		input = &RestoreObjectInput{}
	}

	req := c.newRequest(op, input, &RestoreObjectOutput{})
	return RestoreObjectRequest{Request: req, Input: input, Copy: c.RestoreObjectRequest}
}

// RestoreObjectRequest is the request type for the
// RestoreObject API operation.
type RestoreObjectRequest struct {
	*aws.Request
	Input *RestoreObjectInput
	Copy  func(*RestoreObjectInput) RestoreObjectRequest
}

// Send marshals and sends the RestoreObject API request.
func (r RestoreObjectRequest) Send(ctx context.Context) (*RestoreObjectResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RestoreObjectResponse{
		RestoreObjectOutput: r.Request.Data.(*RestoreObjectOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RestoreObjectResponse is the response type for the
// RestoreObject API operation.
type RestoreObjectResponse struct {
	*RestoreObjectOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RestoreObject request.
func (r *RestoreObjectResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
