// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLoggingRequest
type PutBucketLoggingInput struct {
	_ struct{} `type:"structure" payload:"BucketLoggingStatus"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// BucketLoggingStatus is a required field
	BucketLoggingStatus *BucketLoggingStatus `locationName:"BucketLoggingStatus" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`
}

// String returns the string representation
func (s PutBucketLoggingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBucketLoggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutBucketLoggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.BucketLoggingStatus == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketLoggingStatus"))
	}
	if s.BucketLoggingStatus != nil {
		if err := s.BucketLoggingStatus.Validate(); err != nil {
			invalidParams.AddNested("BucketLoggingStatus", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutBucketLoggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLoggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.BucketLoggingStatus != nil {
		v := s.BucketLoggingStatus

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "BucketLoggingStatus", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLoggingOutput
type PutBucketLoggingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutBucketLoggingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutBucketLoggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opPutBucketLogging = "PutBucketLogging"

// PutBucketLoggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Set the logging parameters for a bucket and to specify permissions for who
// can view and modify the logging parameters. To set the logging status of
// a bucket, you must be the bucket owner.
//
//    // Example sending a request using PutBucketLoggingRequest.
//    req := client.PutBucketLoggingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutBucketLogging
func (c *Client) PutBucketLoggingRequest(input *PutBucketLoggingInput) PutBucketLoggingRequest {
	op := &aws.Operation{
		Name:       opPutBucketLogging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}?logging",
	}

	if input == nil {
		input = &PutBucketLoggingInput{}
	}

	req := c.newRequest(op, input, &PutBucketLoggingOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutBucketLoggingRequest{Request: req, Input: input, Copy: c.PutBucketLoggingRequest}
}

// PutBucketLoggingRequest is the request type for the
// PutBucketLogging API operation.
type PutBucketLoggingRequest struct {
	*aws.Request
	Input *PutBucketLoggingInput
	Copy  func(*PutBucketLoggingInput) PutBucketLoggingRequest
}

// Send marshals and sends the PutBucketLogging API request.
func (r PutBucketLoggingRequest) Send(ctx context.Context) (*PutBucketLoggingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutBucketLoggingResponse{
		PutBucketLoggingOutput: r.Request.Data.(*PutBucketLoggingOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutBucketLoggingResponse is the response type for the
// PutBucketLogging API operation.
type PutBucketLoggingResponse struct {
	*PutBucketLoggingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutBucketLogging request.
func (r *PutBucketLoggingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
