// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53resolver

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleRequest
type GetResolverRuleInput struct {
	_ struct{} `type:"structure"`

	// The ID of the resolver rule that you want to get information about.
	//
	// ResolverRuleId is a required field
	ResolverRuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetResolverRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResolverRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetResolverRuleInput"}

	if s.ResolverRuleId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResolverRuleId"))
	}
	if s.ResolverRuleId != nil && len(*s.ResolverRuleId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResolverRuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRuleResponse
type GetResolverRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the resolver rule that you specified in a GetResolverRule
	// request.
	ResolverRule *ResolverRule `type:"structure"`
}

// String returns the string representation
func (s GetResolverRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetResolverRule = "GetResolverRule"

// GetResolverRuleRequest returns a request value for making API operation for
// Amazon Route 53 Resolver.
//
// Gets information about a specified resolver rule, such as the domain name
// that the rule forwards DNS queries for and the ID of the outbound resolver
// endpoint that the rule is associated with.
//
//    // Example sending a request using GetResolverRuleRequest.
//    req := client.GetResolverRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53resolver-2018-04-01/GetResolverRule
func (c *Client) GetResolverRuleRequest(input *GetResolverRuleInput) GetResolverRuleRequest {
	op := &aws.Operation{
		Name:       opGetResolverRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResolverRuleInput{}
	}

	req := c.newRequest(op, input, &GetResolverRuleOutput{})
	return GetResolverRuleRequest{Request: req, Input: input, Copy: c.GetResolverRuleRequest}
}

// GetResolverRuleRequest is the request type for the
// GetResolverRule API operation.
type GetResolverRuleRequest struct {
	*aws.Request
	Input *GetResolverRuleInput
	Copy  func(*GetResolverRuleInput) GetResolverRuleRequest
}

// Send marshals and sends the GetResolverRule API request.
func (r GetResolverRuleRequest) Send(ctx context.Context) (*GetResolverRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetResolverRuleResponse{
		GetResolverRuleOutput: r.Request.Data.(*GetResolverRuleOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetResolverRuleResponse is the response type for the
// GetResolverRule API operation.
type GetResolverRuleResponse struct {
	*GetResolverRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetResolverRule request.
func (r *GetResolverRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
