// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccessMessage
type RevokeSnapshotAccessInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the AWS customer account that can no longer restore the
	// specified snapshot.
	//
	// AccountWithRestoreAccess is a required field
	AccountWithRestoreAccess *string `type:"string" required:"true"`

	// The identifier of the cluster the snapshot was created from. This parameter
	// is required if your IAM user has a policy containing a snapshot resource
	// element that specifies anything other than * for the cluster name.
	SnapshotClusterIdentifier *string `type:"string"`

	// The identifier of the snapshot that the account can no longer access.
	//
	// SnapshotIdentifier is a required field
	SnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RevokeSnapshotAccessInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeSnapshotAccessInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RevokeSnapshotAccessInput"}

	if s.AccountWithRestoreAccess == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountWithRestoreAccess"))
	}

	if s.SnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccessResult
type RevokeSnapshotAccessOutput struct {
	_ struct{} `type:"structure"`

	// Describes a snapshot.
	Snapshot *Snapshot `type:"structure"`
}

// String returns the string representation
func (s RevokeSnapshotAccessOutput) String() string {
	return awsutil.Prettify(s)
}

const opRevokeSnapshotAccess = "RevokeSnapshotAccess"

// RevokeSnapshotAccessRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Removes the ability of the specified AWS customer account to restore the
// specified snapshot. If the account is currently restoring the snapshot, the
// restore will run to completion.
//
// For more information about working with snapshots, go to Amazon Redshift
// Snapshots (https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-snapshots.html)
// in the Amazon Redshift Cluster Management Guide.
//
//    // Example sending a request using RevokeSnapshotAccessRequest.
//    req := client.RevokeSnapshotAccessRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/RevokeSnapshotAccess
func (c *Client) RevokeSnapshotAccessRequest(input *RevokeSnapshotAccessInput) RevokeSnapshotAccessRequest {
	op := &aws.Operation{
		Name:       opRevokeSnapshotAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeSnapshotAccessInput{}
	}

	req := c.newRequest(op, input, &RevokeSnapshotAccessOutput{})
	return RevokeSnapshotAccessRequest{Request: req, Input: input, Copy: c.RevokeSnapshotAccessRequest}
}

// RevokeSnapshotAccessRequest is the request type for the
// RevokeSnapshotAccess API operation.
type RevokeSnapshotAccessRequest struct {
	*aws.Request
	Input *RevokeSnapshotAccessInput
	Copy  func(*RevokeSnapshotAccessInput) RevokeSnapshotAccessRequest
}

// Send marshals and sends the RevokeSnapshotAccess API request.
func (r RevokeSnapshotAccessRequest) Send(ctx context.Context) (*RevokeSnapshotAccessResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RevokeSnapshotAccessResponse{
		RevokeSnapshotAccessOutput: r.Request.Data.(*RevokeSnapshotAccessOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RevokeSnapshotAccessResponse is the response type for the
// RevokeSnapshotAccess API operation.
type RevokeSnapshotAccessResponse struct {
	*RevokeSnapshotAccessOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RevokeSnapshotAccess request.
func (r *RevokeSnapshotAccessResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
