// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package rdsdataiface provides an interface to enable mocking the AWS RDS DataService service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package rdsdataiface

import (
	"github.com/aws/aws-sdk-go-v2/service/rdsdata"
)

// ClientAPI provides an interface to enable mocking the
// rdsdata.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS RDS DataService.
//    func myFunc(svc rdsdataiface.ClientAPI) bool {
//        // Make svc.ExecuteSql request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := rdsdata.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        rdsdataiface.ClientPI
//    }
//    func (m *mockClientClient) ExecuteSql(input *rdsdata.ExecuteSqlInput) (*rdsdata.ExecuteSqlOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	ExecuteSqlRequest(*rdsdata.ExecuteSqlInput) rdsdata.ExecuteSqlRequest
}

var _ ClientAPI = (*rdsdata.Client)(nil)
