// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributesMessage
type DescribeDBSnapshotAttributesInput struct {
	_ struct{} `type:"structure"`

	// The identifier for the DB snapshot to describe the attributes for.
	//
	// DBSnapshotIdentifier is a required field
	DBSnapshotIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDBSnapshotAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBSnapshotAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDBSnapshotAttributesInput"}

	if s.DBSnapshotIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBSnapshotIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributesResult
type DescribeDBSnapshotAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the results of a successful call to the DescribeDBSnapshotAttributes
	// API action.
	//
	// Manual DB snapshot attributes are used to authorize other AWS accounts to
	// copy or restore a manual DB snapshot. For more information, see the ModifyDBSnapshotAttribute
	// API action.
	DBSnapshotAttributesResult *DBSnapshotAttributesResult `type:"structure"`
}

// String returns the string representation
func (s DescribeDBSnapshotAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDBSnapshotAttributes = "DescribeDBSnapshotAttributes"

// DescribeDBSnapshotAttributesRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Returns a list of DB snapshot attribute names and values for a manual DB
// snapshot.
//
// When sharing snapshots with other AWS accounts, DescribeDBSnapshotAttributes
// returns the restore attribute and a list of IDs for the AWS accounts that
// are authorized to copy or restore the manual DB snapshot. If all is included
// in the list of values for the restore attribute, then the manual DB snapshot
// is public and can be copied or restored by all AWS accounts.
//
// To add or remove access for an AWS account to copy or restore a manual DB
// snapshot, or to make the manual DB snapshot public or private, use the ModifyDBSnapshotAttribute
// API action.
//
//    // Example sending a request using DescribeDBSnapshotAttributesRequest.
//    req := client.DescribeDBSnapshotAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSnapshotAttributes
func (c *Client) DescribeDBSnapshotAttributesRequest(input *DescribeDBSnapshotAttributesInput) DescribeDBSnapshotAttributesRequest {
	op := &aws.Operation{
		Name:       opDescribeDBSnapshotAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDBSnapshotAttributesInput{}
	}

	req := c.newRequest(op, input, &DescribeDBSnapshotAttributesOutput{})
	return DescribeDBSnapshotAttributesRequest{Request: req, Input: input, Copy: c.DescribeDBSnapshotAttributesRequest}
}

// DescribeDBSnapshotAttributesRequest is the request type for the
// DescribeDBSnapshotAttributes API operation.
type DescribeDBSnapshotAttributesRequest struct {
	*aws.Request
	Input *DescribeDBSnapshotAttributesInput
	Copy  func(*DescribeDBSnapshotAttributesInput) DescribeDBSnapshotAttributesRequest
}

// Send marshals and sends the DescribeDBSnapshotAttributes API request.
func (r DescribeDBSnapshotAttributesRequest) Send(ctx context.Context) (*DescribeDBSnapshotAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDBSnapshotAttributesResponse{
		DescribeDBSnapshotAttributesOutput: r.Request.Data.(*DescribeDBSnapshotAttributesOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDBSnapshotAttributesResponse is the response type for the
// DescribeDBSnapshotAttributes API operation.
type DescribeDBSnapshotAttributesResponse struct {
	*DescribeDBSnapshotAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDBSnapshotAttributes request.
func (r *DescribeDBSnapshotAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
