// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package rds

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroupsMessage
type DescribeDBSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name of the DB security group to return details for.
	DBSecurityGroupName *string `type:"string"`

	// This parameter is not currently supported.
	Filters []Filter `locationNameList:"Filter" type:"list"`

	// An optional pagination token provided by a previous DescribeDBSecurityGroups
	// request. If this parameter is specified, the response includes only records
	// beyond the marker, up to the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeDBSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDBSecurityGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeDBSecurityGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the result of a successful invocation of the DescribeDBSecurityGroups
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DBSecurityGroupMessage
type DescribeDBSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of DBSecurityGroup instances.
	DBSecurityGroups []DBSecurityGroup `locationNameList:"DBSecurityGroup" type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeDBSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDBSecurityGroups = "DescribeDBSecurityGroups"

// DescribeDBSecurityGroupsRequest returns a request value for making API operation for
// Amazon Relational Database Service.
//
// Returns a list of DBSecurityGroup descriptions. If a DBSecurityGroupName
// is specified, the list will contain only the descriptions of the specified
// DB security group.
//
//    // Example sending a request using DescribeDBSecurityGroupsRequest.
//    req := client.DescribeDBSecurityGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/rds-2014-10-31/DescribeDBSecurityGroups
func (c *Client) DescribeDBSecurityGroupsRequest(input *DescribeDBSecurityGroupsInput) DescribeDBSecurityGroupsRequest {
	op := &aws.Operation{
		Name:       opDescribeDBSecurityGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeDBSecurityGroupsInput{}
	}

	req := c.newRequest(op, input, &DescribeDBSecurityGroupsOutput{})
	return DescribeDBSecurityGroupsRequest{Request: req, Input: input, Copy: c.DescribeDBSecurityGroupsRequest}
}

// DescribeDBSecurityGroupsRequest is the request type for the
// DescribeDBSecurityGroups API operation.
type DescribeDBSecurityGroupsRequest struct {
	*aws.Request
	Input *DescribeDBSecurityGroupsInput
	Copy  func(*DescribeDBSecurityGroupsInput) DescribeDBSecurityGroupsRequest
}

// Send marshals and sends the DescribeDBSecurityGroups API request.
func (r DescribeDBSecurityGroupsRequest) Send(ctx context.Context) (*DescribeDBSecurityGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDBSecurityGroupsResponse{
		DescribeDBSecurityGroupsOutput: r.Request.Data.(*DescribeDBSecurityGroupsOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribeDBSecurityGroupsRequestPaginator returns a paginator for DescribeDBSecurityGroups.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribeDBSecurityGroupsRequest(input)
//   p := rds.NewDescribeDBSecurityGroupsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribeDBSecurityGroupsPaginator(req DescribeDBSecurityGroupsRequest) DescribeDBSecurityGroupsPaginator {
	return DescribeDBSecurityGroupsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribeDBSecurityGroupsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribeDBSecurityGroupsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribeDBSecurityGroupsPaginator struct {
	aws.Pager
}

func (p *DescribeDBSecurityGroupsPaginator) CurrentPage() *DescribeDBSecurityGroupsOutput {
	return p.Pager.CurrentPage().(*DescribeDBSecurityGroupsOutput)
}

// DescribeDBSecurityGroupsResponse is the response type for the
// DescribeDBSecurityGroups API operation.
type DescribeDBSecurityGroupsResponse struct {
	*DescribeDBSecurityGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDBSecurityGroups request.
func (r *DescribeDBSecurityGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
