// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpointemail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request to obtain a list of configuration sets for your Amazon Pinpoint
// account in the current AWS Region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListConfigurationSetsRequest
type ListConfigurationSetsInput struct {
	_ struct{} `type:"structure"`

	// A token returned from a previous call to ListConfigurationSets to indicate
	// the position in the list of configuration sets.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// The number of results to show in a single call to ListConfigurationSets.
	// If the number of results is larger than the number you specified in this
	// parameter, then the response includes a NextToken element, which you can
	// use to obtain additional results.
	PageSize *int64 `location:"querystring" locationName:"PageSize" type:"integer"`
}

// String returns the string representation
func (s ListConfigurationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListConfigurationSetsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PageSize != nil {
		v := *s.PageSize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "PageSize", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A list of configuration sets in your Amazon Pinpoint account in the current
// AWS Region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListConfigurationSetsResponse
type ListConfigurationSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains all of the configuration sets in your Amazon Pinpoint
	// account in the current AWS Region.
	ConfigurationSets []string `type:"list"`

	// A token that indicates that there are additional configuration sets to list.
	// To view additional configuration sets, issue another request to ListConfigurationSets,
	// and pass this token in the NextToken parameter.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListConfigurationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListConfigurationSetsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ConfigurationSets) > 0 {
		v := s.ConfigurationSets

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ConfigurationSets", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListConfigurationSets = "ListConfigurationSets"

// ListConfigurationSetsRequest returns a request value for making API operation for
// Amazon Pinpoint Email Service.
//
// List all of the configuration sets associated with your Amazon Pinpoint account
// in the current region.
//
// In Amazon Pinpoint, configuration sets are groups of rules that you can apply
// to the emails you send. You apply a configuration set to an email by including
// a reference to the configuration set in the headers of the email. When you
// apply a configuration set to an email, all of the rules in that configuration
// set are applied to the email.
//
//    // Example sending a request using ListConfigurationSetsRequest.
//    req := client.ListConfigurationSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-email-2018-07-26/ListConfigurationSets
func (c *Client) ListConfigurationSetsRequest(input *ListConfigurationSetsInput) ListConfigurationSetsRequest {
	op := &aws.Operation{
		Name:       opListConfigurationSets,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/email/configuration-sets",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "PageSize",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListConfigurationSetsInput{}
	}

	req := c.newRequest(op, input, &ListConfigurationSetsOutput{})
	return ListConfigurationSetsRequest{Request: req, Input: input, Copy: c.ListConfigurationSetsRequest}
}

// ListConfigurationSetsRequest is the request type for the
// ListConfigurationSets API operation.
type ListConfigurationSetsRequest struct {
	*aws.Request
	Input *ListConfigurationSetsInput
	Copy  func(*ListConfigurationSetsInput) ListConfigurationSetsRequest
}

// Send marshals and sends the ListConfigurationSets API request.
func (r ListConfigurationSetsRequest) Send(ctx context.Context) (*ListConfigurationSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListConfigurationSetsResponse{
		ListConfigurationSetsOutput: r.Request.Data.(*ListConfigurationSetsOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListConfigurationSetsRequestPaginator returns a paginator for ListConfigurationSets.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListConfigurationSetsRequest(input)
//   p := pinpointemail.NewListConfigurationSetsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListConfigurationSetsPaginator(req ListConfigurationSetsRequest) ListConfigurationSetsPaginator {
	return ListConfigurationSetsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListConfigurationSetsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListConfigurationSetsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListConfigurationSetsPaginator struct {
	aws.Pager
}

func (p *ListConfigurationSetsPaginator) CurrentPage() *ListConfigurationSetsOutput {
	return p.Pager.CurrentPage().(*ListConfigurationSetsOutput)
}

// ListConfigurationSetsResponse is the response type for the
// ListConfigurationSets API operation.
type ListConfigurationSetsResponse struct {
	*ListConfigurationSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListConfigurationSets request.
func (r *ListConfigurationSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
