// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatchRequest
type UpdateEndpointsBatchInput struct {
	_ struct{} `type:"structure" payload:"EndpointBatchRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Endpoint batch update request.
	//
	// EndpointBatchRequest is a required field
	EndpointBatchRequest *EndpointBatchRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointsBatchInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointsBatchInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateEndpointsBatchInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.EndpointBatchRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("EndpointBatchRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEndpointsBatchInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EndpointBatchRequest != nil {
		v := s.EndpointBatchRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "EndpointBatchRequest", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatchResponse
type UpdateEndpointsBatchOutput struct {
	_ struct{} `type:"structure" payload:"MessageBody"`

	// Simple message object.
	//
	// MessageBody is a required field
	MessageBody *MessageBody `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateEndpointsBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateEndpointsBatchOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.MessageBody != nil {
		v := s.MessageBody

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "MessageBody", v, metadata)
	}
	return nil
}

const opUpdateEndpointsBatch = "UpdateEndpointsBatch"

// UpdateEndpointsBatchRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Use to update a batch of endpoints.
//
//    // Example sending a request using UpdateEndpointsBatchRequest.
//    req := client.UpdateEndpointsBatchRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateEndpointsBatch
func (c *Client) UpdateEndpointsBatchRequest(input *UpdateEndpointsBatchInput) UpdateEndpointsBatchRequest {
	op := &aws.Operation{
		Name:       opUpdateEndpointsBatch,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/endpoints",
	}

	if input == nil {
		input = &UpdateEndpointsBatchInput{}
	}

	req := c.newRequest(op, input, &UpdateEndpointsBatchOutput{})
	return UpdateEndpointsBatchRequest{Request: req, Input: input, Copy: c.UpdateEndpointsBatchRequest}
}

// UpdateEndpointsBatchRequest is the request type for the
// UpdateEndpointsBatch API operation.
type UpdateEndpointsBatchRequest struct {
	*aws.Request
	Input *UpdateEndpointsBatchInput
	Copy  func(*UpdateEndpointsBatchInput) UpdateEndpointsBatchRequest
}

// Send marshals and sends the UpdateEndpointsBatch API request.
func (r UpdateEndpointsBatchRequest) Send(ctx context.Context) (*UpdateEndpointsBatchResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateEndpointsBatchResponse{
		UpdateEndpointsBatchOutput: r.Request.Data.(*UpdateEndpointsBatchOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateEndpointsBatchResponse is the response type for the
// UpdateEndpointsBatch API operation.
type UpdateEndpointsBatchResponse struct {
	*UpdateEndpointsBatchOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateEndpointsBatch request.
func (r *UpdateEndpointsBatchResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
