// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannelRequest
type UpdateAdmChannelInput struct {
	_ struct{} `type:"structure" payload:"ADMChannelRequest"`

	// Amazon Device Messaging channel definition.
	//
	// ADMChannelRequest is a required field
	ADMChannelRequest *ADMChannelRequest `type:"structure" required:"true"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAdmChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateAdmChannelInput"}

	if s.ADMChannelRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("ADMChannelRequest"))
	}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAdmChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ADMChannelRequest != nil {
		v := s.ADMChannelRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ADMChannelRequest", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannelResponse
type UpdateAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Amazon Device Messaging channel definition.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateAdmChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADMChannelResponse != nil {
		v := s.ADMChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ADMChannelResponse", v, metadata)
	}
	return nil
}

const opUpdateAdmChannel = "UpdateAdmChannel"

// UpdateAdmChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Update an ADM channel.
//
//    // Example sending a request using UpdateAdmChannelRequest.
//    req := client.UpdateAdmChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/UpdateAdmChannel
func (c *Client) UpdateAdmChannelRequest(input *UpdateAdmChannelInput) UpdateAdmChannelRequest {
	op := &aws.Operation{
		Name:       opUpdateAdmChannel,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &UpdateAdmChannelInput{}
	}

	req := c.newRequest(op, input, &UpdateAdmChannelOutput{})
	return UpdateAdmChannelRequest{Request: req, Input: input, Copy: c.UpdateAdmChannelRequest}
}

// UpdateAdmChannelRequest is the request type for the
// UpdateAdmChannel API operation.
type UpdateAdmChannelRequest struct {
	*aws.Request
	Input *UpdateAdmChannelInput
	Copy  func(*UpdateAdmChannelInput) UpdateAdmChannelRequest
}

// Send marshals and sends the UpdateAdmChannel API request.
func (r UpdateAdmChannelRequest) Send(ctx context.Context) (*UpdateAdmChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateAdmChannelResponse{
		UpdateAdmChannelOutput: r.Request.Data.(*UpdateAdmChannelOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateAdmChannelResponse is the response type for the
// UpdateAdmChannel API operation.
type UpdateAdmChannelResponse struct {
	*UpdateAdmChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateAdmChannel request.
func (r *UpdateAdmChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
