// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJobRequest
type CreateExportJobInput struct {
	_ struct{} `type:"structure" payload:"ExportJobRequest"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`

	// Export job request.
	//
	// ExportJobRequest is a required field
	ExportJobRequest *ExportJobRequest `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateExportJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateExportJobInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.ExportJobRequest == nil {
		invalidParams.Add(aws.NewErrParamRequired("ExportJobRequest"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateExportJobInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExportJobRequest != nil {
		v := s.ExportJobRequest

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ExportJobRequest", v, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJobResponse
type CreateExportJobOutput struct {
	_ struct{} `type:"structure" payload:"ExportJobResponse"`

	// Export job response.
	//
	// ExportJobResponse is a required field
	ExportJobResponse *ExportJobResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateExportJobOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ExportJobResponse != nil {
		v := s.ExportJobResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ExportJobResponse", v, metadata)
	}
	return nil
}

const opCreateExportJob = "CreateExportJob"

// CreateExportJobRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Creates an export job.
//
//    // Example sending a request using CreateExportJobRequest.
//    req := client.CreateExportJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/CreateExportJob
func (c *Client) CreateExportJobRequest(input *CreateExportJobInput) CreateExportJobRequest {
	op := &aws.Operation{
		Name:       opCreateExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/apps/{application-id}/jobs/export",
	}

	if input == nil {
		input = &CreateExportJobInput{}
	}

	req := c.newRequest(op, input, &CreateExportJobOutput{})
	return CreateExportJobRequest{Request: req, Input: input, Copy: c.CreateExportJobRequest}
}

// CreateExportJobRequest is the request type for the
// CreateExportJob API operation.
type CreateExportJobRequest struct {
	*aws.Request
	Input *CreateExportJobInput
	Copy  func(*CreateExportJobInput) CreateExportJobRequest
}

// Send marshals and sends the CreateExportJob API request.
func (r CreateExportJobRequest) Send(ctx context.Context) (*CreateExportJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateExportJobResponse{
		CreateExportJobOutput: r.Request.Data.(*CreateExportJobOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateExportJobResponse is the response type for the
// CreateExportJob API operation.
type CreateExportJobResponse struct {
	*CreateExportJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateExportJob request.
func (r *CreateExportJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
