// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package organizations

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTargetRequest
type ListPoliciesForTargetInput struct {
	_ struct{} `type:"structure"`

	// The type of policy that you want to include in the returned list.
	//
	// Filter is a required field
	Filter PolicyType `type:"string" required:"true" enum:"true"`

	// (Optional) Use this to limit the number of results you want included per
	// page in the response. If you do not include this parameter, it defaults to
	// a value that is specific to the operation. If additional items exist beyond
	// the maximum you specify, the NextToken response element is present and has
	// a value (is not null). Include that value as the NextToken request parameter
	// in the next call to the operation to get the next part of the results. Note
	// that Organizations might return fewer results than the maximum even when
	// there are more results available. You should check NextToken after every
	// operation to ensure that you receive all of the results.
	MaxResults *int64 `min:"1" type:"integer"`

	// Use this parameter if you receive a NextToken response in a previous request
	// that indicates that there is more output available. Set it to the value of
	// the previous call's NextToken response to indicate where the output should
	// continue from.
	NextToken *string `type:"string"`

	// The unique identifier (ID) of the root, organizational unit, or account whose
	// policies you want to list.
	//
	// The regex pattern (http://wikipedia.org/wiki/regex) for a target ID string
	// requires one of the following:
	//
	//    * Root: a string that begins with "r-" followed by from 4 to 32 lower-case
	//    letters or digits.
	//
	//    * Account: a string that consists of exactly 12 digits.
	//
	//    * Organizational unit (OU): a string that begins with "ou-" followed by
	//    from 4 to 32 lower-case letters or digits (the ID of the root that the
	//    OU is in) followed by a second "-" dash and from 8 to 32 additional lower-case
	//    letters or digits.
	//
	// TargetId is a required field
	TargetId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListPoliciesForTargetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoliciesForTargetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPoliciesForTargetInput"}
	if len(s.Filter) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Filter"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.TargetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTargetResponse
type ListPoliciesForTargetOutput struct {
	_ struct{} `type:"structure"`

	// If present, this value indicates that there is more output available than
	// is included in the current response. Use this value in the NextToken request
	// parameter in a subsequent call to the operation to get the next part of the
	// output. You should repeat this until the NextToken response element comes
	// back as null.
	NextToken *string `type:"string"`

	// The list of policies that match the criteria in the request.
	Policies []PolicySummary `type:"list"`
}

// String returns the string representation
func (s ListPoliciesForTargetOutput) String() string {
	return awsutil.Prettify(s)
}

const opListPoliciesForTarget = "ListPoliciesForTarget"

// ListPoliciesForTargetRequest returns a request value for making API operation for
// AWS Organizations.
//
// Lists the policies that are directly attached to the specified target root,
// organizational unit (OU), or account. You must specify the policy type that
// you want included in the returned list.
//
// Always check the NextToken response parameter for a null value when calling
// a List* operation. These operations can occasionally return an empty set
// of results even when there are more results available. The NextToken response
// parameter value is null only when there are no more results to display.
//
// This operation can be called only from the organization's master account.
//
//    // Example sending a request using ListPoliciesForTargetRequest.
//    req := client.ListPoliciesForTargetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/organizations-2016-11-28/ListPoliciesForTarget
func (c *Client) ListPoliciesForTargetRequest(input *ListPoliciesForTargetInput) ListPoliciesForTargetRequest {
	op := &aws.Operation{
		Name:       opListPoliciesForTarget,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPoliciesForTargetInput{}
	}

	req := c.newRequest(op, input, &ListPoliciesForTargetOutput{})
	return ListPoliciesForTargetRequest{Request: req, Input: input, Copy: c.ListPoliciesForTargetRequest}
}

// ListPoliciesForTargetRequest is the request type for the
// ListPoliciesForTarget API operation.
type ListPoliciesForTargetRequest struct {
	*aws.Request
	Input *ListPoliciesForTargetInput
	Copy  func(*ListPoliciesForTargetInput) ListPoliciesForTargetRequest
}

// Send marshals and sends the ListPoliciesForTarget API request.
func (r ListPoliciesForTargetRequest) Send(ctx context.Context) (*ListPoliciesForTargetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPoliciesForTargetResponse{
		ListPoliciesForTargetOutput: r.Request.Data.(*ListPoliciesForTargetOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPoliciesForTargetRequestPaginator returns a paginator for ListPoliciesForTarget.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPoliciesForTargetRequest(input)
//   p := organizations.NewListPoliciesForTargetRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPoliciesForTargetPaginator(req ListPoliciesForTargetRequest) ListPoliciesForTargetPaginator {
	return ListPoliciesForTargetPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPoliciesForTargetInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPoliciesForTargetPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPoliciesForTargetPaginator struct {
	aws.Pager
}

func (p *ListPoliciesForTargetPaginator) CurrentPage() *ListPoliciesForTargetOutput {
	return p.Pager.CurrentPage().(*ListPoliciesForTargetOutput)
}

// ListPoliciesForTargetResponse is the response type for the
// ListPoliciesForTarget API operation.
type ListPoliciesForTargetResponse struct {
	*ListPoliciesForTargetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPoliciesForTarget request.
func (r *ListPoliciesForTargetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
