// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignVolumeRequest
type UnassignVolumeInput struct {
	_ struct{} `type:"structure"`

	// The volume ID.
	//
	// VolumeId is a required field
	VolumeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UnassignVolumeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UnassignVolumeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UnassignVolumeInput"}

	if s.VolumeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VolumeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignVolumeOutput
type UnassignVolumeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UnassignVolumeOutput) String() string {
	return awsutil.Prettify(s)
}

const opUnassignVolume = "UnassignVolume"

// UnassignVolumeRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Unassigns an assigned Amazon EBS volume. The volume remains registered with
// the stack. For more information, see Resource Management (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using UnassignVolumeRequest.
//    req := client.UnassignVolumeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/UnassignVolume
func (c *Client) UnassignVolumeRequest(input *UnassignVolumeInput) UnassignVolumeRequest {
	op := &aws.Operation{
		Name:       opUnassignVolume,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnassignVolumeInput{}
	}

	req := c.newRequest(op, input, &UnassignVolumeOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return UnassignVolumeRequest{Request: req, Input: input, Copy: c.UnassignVolumeRequest}
}

// UnassignVolumeRequest is the request type for the
// UnassignVolume API operation.
type UnassignVolumeRequest struct {
	*aws.Request
	Input *UnassignVolumeInput
	Copy  func(*UnassignVolumeInput) UnassignVolumeRequest
}

// Send marshals and sends the UnassignVolume API request.
func (r UnassignVolumeRequest) Send(ctx context.Context) (*UnassignVolumeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UnassignVolumeResponse{
		UnassignVolumeOutput: r.Request.Data.(*UnassignVolumeOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UnassignVolumeResponse is the response type for the
// UnassignVolume API operation.
type UnassignVolumeResponse struct {
	*UnassignVolumeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UnassignVolume request.
func (r *UnassignVolumeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
