// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateNotificationSettingsRequest
type UpdateNotificationSettingsInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether notifications are sent for HITs of this HIT type, according
	// to the notification specification. You must specify either the Notification
	// parameter or the Active parameter for the call to UpdateNotificationSettings
	// to succeed.
	Active *bool `type:"boolean"`

	// The ID of the HIT type whose notification specification is being updated.
	//
	// HITTypeId is a required field
	HITTypeId *string `min:"1" type:"string" required:"true"`

	// The notification specification for the HIT type.
	Notification *NotificationSpecification `type:"structure"`
}

// String returns the string representation
func (s UpdateNotificationSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNotificationSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateNotificationSettingsInput"}

	if s.HITTypeId == nil {
		invalidParams.Add(aws.NewErrParamRequired("HITTypeId"))
	}
	if s.HITTypeId != nil && len(*s.HITTypeId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HITTypeId", 1))
	}
	if s.Notification != nil {
		if err := s.Notification.Validate(); err != nil {
			invalidParams.AddNested("Notification", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateNotificationSettingsResponse
type UpdateNotificationSettingsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateNotificationSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateNotificationSettings = "UpdateNotificationSettings"

// UpdateNotificationSettingsRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The UpdateNotificationSettings operation creates, updates, disables or re-enables
// notifications for a HIT type. If you call the UpdateNotificationSettings
// operation for a HIT type that already has a notification specification, the
// operation replaces the old specification with a new one. You can call the
// UpdateNotificationSettings operation to enable or disable notifications for
// the HIT type, without having to modify the notification specification itself
// by providing updates to the Active status without specifying a new notification
// specification. To change the Active status of a HIT type's notifications,
// the HIT type must already have a notification specification, or one must
// be provided in the same call to UpdateNotificationSettings.
//
//    // Example sending a request using UpdateNotificationSettingsRequest.
//    req := client.UpdateNotificationSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/UpdateNotificationSettings
func (c *Client) UpdateNotificationSettingsRequest(input *UpdateNotificationSettingsInput) UpdateNotificationSettingsRequest {
	op := &aws.Operation{
		Name:       opUpdateNotificationSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotificationSettingsInput{}
	}

	req := c.newRequest(op, input, &UpdateNotificationSettingsOutput{})
	return UpdateNotificationSettingsRequest{Request: req, Input: input, Copy: c.UpdateNotificationSettingsRequest}
}

// UpdateNotificationSettingsRequest is the request type for the
// UpdateNotificationSettings API operation.
type UpdateNotificationSettingsRequest struct {
	*aws.Request
	Input *UpdateNotificationSettingsInput
	Copy  func(*UpdateNotificationSettingsInput) UpdateNotificationSettingsRequest
}

// Send marshals and sends the UpdateNotificationSettings API request.
func (r UpdateNotificationSettingsRequest) Send(ctx context.Context) (*UpdateNotificationSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateNotificationSettingsResponse{
		UpdateNotificationSettingsOutput: r.Request.Data.(*UpdateNotificationSettingsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateNotificationSettingsResponse is the response type for the
// UpdateNotificationSettings API operation.
type UpdateNotificationSettingsResponse struct {
	*UpdateNotificationSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateNotificationSettings request.
func (r *UpdateNotificationSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
