// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mturk

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITRequest
type CreateHITInput struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, that a Worker has to complete the HIT after
	// accepting it. If a Worker does not complete the assignment within the specified
	// duration, the assignment is considered abandoned. If the HIT is still active
	// (that is, its lifetime has not elapsed), the assignment becomes available
	// for other users to find and accept.
	//
	// AssignmentDurationInSeconds is a required field
	AssignmentDurationInSeconds *int64 `type:"long" required:"true"`

	// The Assignment-level Review Policy applies to the assignments under the HIT.
	// You can specify for Mechanical Turk to take various actions based on the
	// policy.
	AssignmentReviewPolicy *ReviewPolicy `type:"structure"`

	// The number of seconds after an assignment for the HIT has been submitted,
	// after which the assignment is considered Approved automatically unless the
	// Requester explicitly rejects it.
	AutoApprovalDelayInSeconds *int64 `type:"long"`

	// A general description of the HIT. A description includes detailed information
	// about the kind of task the HIT contains. On the Amazon Mechanical Turk web
	// site, the HIT description appears in the expanded view of search results,
	// and in the HIT and assignment screens. A good description gives the user
	// enough information to evaluate the HIT before accepting it.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// The HITLayoutId allows you to use a pre-existing HIT design with placeholder
	// values and create an additional HIT by providing those values as HITLayoutParameters.
	//
	// Constraints: Either a Question parameter or a HITLayoutId parameter must
	// be provided.
	HITLayoutId *string `min:"1" type:"string"`

	// If the HITLayoutId is provided, any placeholder values must be filled in
	// with values using the HITLayoutParameter structure. For more information,
	// see HITLayout.
	HITLayoutParameters []HITLayoutParameter `type:"list"`

	// The HIT-level Review Policy applies to the HIT. You can specify for Mechanical
	// Turk to take various actions based on the policy.
	HITReviewPolicy *ReviewPolicy `type:"structure"`

	// One or more words or phrases that describe the HIT, separated by commas.
	// These words are used in searches to find HITs.
	Keywords *string `type:"string"`

	// An amount of time, in seconds, after which the HIT is no longer available
	// for users to accept. After the lifetime of the HIT elapses, the HIT no longer
	// appears in HIT searches, even if not all of the assignments for the HIT have
	// been accepted.
	//
	// LifetimeInSeconds is a required field
	LifetimeInSeconds *int64 `type:"long" required:"true"`

	// The number of times the HIT can be accepted and completed before the HIT
	// becomes unavailable.
	MaxAssignments *int64 `type:"integer"`

	// Conditions that a Worker's Qualifications must meet in order to accept the
	// HIT. A HIT can have between zero and ten Qualification requirements. All
	// requirements must be met in order for a Worker to accept the HIT. Additionally,
	// other actions can be restricted using the ActionsGuarded field on each QualificationRequirement
	// structure.
	QualificationRequirements []QualificationRequirement `type:"list"`

	// The data the person completing the HIT uses to produce the results.
	//
	// Constraints: Must be a QuestionForm data structure, an ExternalQuestion data
	// structure, or an HTMLQuestion data structure. The XML question data must
	// not be larger than 64 kilobytes (65,535 bytes) in size, including whitespace.
	//
	// Either a Question parameter or a HITLayoutId parameter must be provided.
	Question *string `type:"string"`

	// An arbitrary data field. The RequesterAnnotation parameter lets your application
	// attach arbitrary data to the HIT for tracking purposes. For example, this
	// parameter could be an identifier internal to the Requester's application
	// that corresponds with the HIT.
	//
	// The RequesterAnnotation parameter for a HIT is only visible to the Requester
	// who created the HIT. It is not shown to the Worker, or any other Requester.
	//
	// The RequesterAnnotation parameter may be different for each HIT you submit.
	// It does not affect how your HITs are grouped.
	RequesterAnnotation *string `type:"string"`

	// The amount of money the Requester will pay a Worker for successfully completing
	// the HIT.
	//
	// Reward is a required field
	Reward *string `type:"string" required:"true"`

	// The title of the HIT. A title should be short and descriptive about the kind
	// of task the HIT contains. On the Amazon Mechanical Turk web site, the HIT
	// title appears in search results, and everywhere the HIT is mentioned.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`

	// A unique identifier for this request which allows you to retry the call on
	// error without creating duplicate HITs. This is useful in cases such as network
	// timeouts where it is unclear whether or not the call succeeded on the server.
	// If the HIT already exists in the system from a previous call using the same
	// UniqueRequestToken, subsequent calls will return a AWS.MechanicalTurk.HitAlreadyExists
	// error with a message containing the HITId.
	//
	// Note: It is your responsibility to ensure uniqueness of the token. The unique
	// token expires after 24 hours. Subsequent calls using the same UniqueRequestToken
	// made after the 24 hour limit could create duplicate HITs.
	UniqueRequestToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateHITInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHITInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateHITInput"}

	if s.AssignmentDurationInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssignmentDurationInSeconds"))
	}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}
	if s.HITLayoutId != nil && len(*s.HITLayoutId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HITLayoutId", 1))
	}

	if s.LifetimeInSeconds == nil {
		invalidParams.Add(aws.NewErrParamRequired("LifetimeInSeconds"))
	}

	if s.Reward == nil {
		invalidParams.Add(aws.NewErrParamRequired("Reward"))
	}

	if s.Title == nil {
		invalidParams.Add(aws.NewErrParamRequired("Title"))
	}
	if s.UniqueRequestToken != nil && len(*s.UniqueRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UniqueRequestToken", 1))
	}
	if s.AssignmentReviewPolicy != nil {
		if err := s.AssignmentReviewPolicy.Validate(); err != nil {
			invalidParams.AddNested("AssignmentReviewPolicy", err.(aws.ErrInvalidParams))
		}
	}
	if s.HITLayoutParameters != nil {
		for i, v := range s.HITLayoutParameters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "HITLayoutParameters", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.HITReviewPolicy != nil {
		if err := s.HITReviewPolicy.Validate(); err != nil {
			invalidParams.AddNested("HITReviewPolicy", err.(aws.ErrInvalidParams))
		}
	}
	if s.QualificationRequirements != nil {
		for i, v := range s.QualificationRequirements {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QualificationRequirements", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHITResponse
type CreateHITOutput struct {
	_ struct{} `type:"structure"`

	// Contains the newly created HIT data. For a description of the HIT data structure
	// as it appears in responses, see the HIT Data Structure documentation.
	HIT *HIT `type:"structure"`
}

// String returns the string representation
func (s CreateHITOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateHIT = "CreateHIT"

// CreateHITRequest returns a request value for making API operation for
// Amazon Mechanical Turk.
//
// The CreateHIT operation creates a new Human Intelligence Task (HIT). The
// new HIT is made available for Workers to find and accept on the Amazon Mechanical
// Turk website.
//
// This operation allows you to specify a new HIT by passing in values for the
// properties of the HIT, such as its title, reward amount and number of assignments.
// When you pass these values to CreateHIT, a new HIT is created for you, with
// a new HITTypeID. The HITTypeID can be used to create additional HITs in the
// future without needing to specify common parameters such as the title, description
// and reward amount each time.
//
// An alternative way to create HITs is to first generate a HITTypeID using
// the CreateHITType operation and then call the CreateHITWithHITType operation.
// This is the recommended best practice for Requesters who are creating large
// numbers of HITs.
//
// CreateHIT also supports several ways to provide question data: by providing
// a value for the Question parameter that fully specifies the contents of the
// HIT, or by providing a HitLayoutId and associated HitLayoutParameters.
//
// If a HIT is created with 10 or more maximum assignments, there is an additional
// fee. For more information, see Amazon Mechanical Turk Pricing (https://requester.mturk.com/pricing).
//
//    // Example sending a request using CreateHITRequest.
//    req := client.CreateHITRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mturk-requester-2017-01-17/CreateHIT
func (c *Client) CreateHITRequest(input *CreateHITInput) CreateHITRequest {
	op := &aws.Operation{
		Name:       opCreateHIT,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHITInput{}
	}

	req := c.newRequest(op, input, &CreateHITOutput{})
	return CreateHITRequest{Request: req, Input: input, Copy: c.CreateHITRequest}
}

// CreateHITRequest is the request type for the
// CreateHIT API operation.
type CreateHITRequest struct {
	*aws.Request
	Input *CreateHITInput
	Copy  func(*CreateHITInput) CreateHITRequest
}

// Send marshals and sends the CreateHIT API request.
func (r CreateHITRequest) Send(ctx context.Context) (*CreateHITResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateHITResponse{
		CreateHITOutput: r.Request.Data.(*CreateHITOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateHITResponse is the response type for the
// CreateHIT API operation.
type CreateHITResponse struct {
	*CreateHITOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateHIT request.
func (r *CreateHITResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
