// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package managedblockchain

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNodeInput
type CreateNodeInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the operation. An idempotent operation completes no more than one time.
	// This identifier is required only if you make a service request directly using
	// an HTTP client. It is generated automatically if you use an AWS SDK or the
	// AWS CLI.
	//
	// ClientRequestToken is a required field
	ClientRequestToken *string `min:"1" type:"string" required:"true" idempotencyToken:"true"`

	// The unique identifier of the member that owns this node.
	//
	// MemberId is a required field
	MemberId *string `location:"uri" locationName:"memberId" min:"1" type:"string" required:"true"`

	// The unique identifier of the network in which this node runs.
	//
	// NetworkId is a required field
	NetworkId *string `location:"uri" locationName:"networkId" min:"1" type:"string" required:"true"`

	// The properties of a node configuration.
	//
	// NodeConfiguration is a required field
	NodeConfiguration *NodeConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s CreateNodeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNodeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateNodeInput"}

	if s.ClientRequestToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientRequestToken"))
	}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.MemberId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MemberId"))
	}
	if s.MemberId != nil && len(*s.MemberId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("MemberId", 1))
	}

	if s.NetworkId == nil {
		invalidParams.Add(aws.NewErrParamRequired("NetworkId"))
	}
	if s.NetworkId != nil && len(*s.NetworkId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NetworkId", 1))
	}

	if s.NodeConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodeConfiguration"))
	}
	if s.NodeConfiguration != nil {
		if err := s.NodeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NodeConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateNodeInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ClientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodeConfiguration != nil {
		v := s.NodeConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "NodeConfiguration", v, metadata)
	}
	if s.MemberId != nil {
		v := *s.MemberId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "memberId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NetworkId != nil {
		v := *s.NetworkId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "networkId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNodeOutput
type CreateNodeOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the node.
	NodeId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateNodeOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NodeId != nil {
		v := *s.NodeId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NodeId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateNode = "CreateNode"

// CreateNodeRequest returns a request value for making API operation for
// Amazon Managed Blockchain.
//
// Creates a peer node in a member.
//
//    // Example sending a request using CreateNodeRequest.
//    req := client.CreateNodeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-2018-09-24/CreateNode
func (c *Client) CreateNodeRequest(input *CreateNodeInput) CreateNodeRequest {
	op := &aws.Operation{
		Name:       opCreateNode,
		HTTPMethod: "POST",
		HTTPPath:   "/networks/{networkId}/members/{memberId}/nodes",
	}

	if input == nil {
		input = &CreateNodeInput{}
	}

	req := c.newRequest(op, input, &CreateNodeOutput{})
	return CreateNodeRequest{Request: req, Input: input, Copy: c.CreateNodeRequest}
}

// CreateNodeRequest is the request type for the
// CreateNode API operation.
type CreateNodeRequest struct {
	*aws.Request
	Input *CreateNodeInput
	Copy  func(*CreateNodeInput) CreateNodeRequest
}

// Send marshals and sends the CreateNode API request.
func (r CreateNodeRequest) Send(ctx context.Context) (*CreateNodeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateNodeResponse{
		CreateNodeOutput: r.Request.Data.(*CreateNodeOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateNodeResponse is the response type for the
// CreateNode API operation.
type CreateNodeResponse struct {
	*CreateNodeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateNode request.
func (r *CreateNodeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
