// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPortsRequest
type PutInstancePublicPortsInput struct {
	_ struct{} `type:"structure"`

	// The Lightsail instance name of the public port(s) you are setting.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`

	// Specifies information about the public port(s).
	//
	// PortInfos is a required field
	PortInfos []PortInfo `locationName:"portInfos" type:"list" required:"true"`
}

// String returns the string representation
func (s PutInstancePublicPortsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutInstancePublicPortsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutInstancePublicPortsInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if s.PortInfos == nil {
		invalidParams.Add(aws.NewErrParamRequired("PortInfos"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPortsResult
type PutInstancePublicPortsOutput struct {
	_ struct{} `type:"structure"`

	// Describes metadata about the operation you just executed.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s PutInstancePublicPortsOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutInstancePublicPorts = "PutInstancePublicPorts"

// PutInstancePublicPortsRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Sets the specified open ports for an Amazon Lightsail instance, and closes
// all ports for every protocol not included in the current request.
//
// The put instance public ports operation supports tag-based access control
// via resource tags applied to the resource identified by instanceName. For
// more information, see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using PutInstancePublicPortsRequest.
//    req := client.PutInstancePublicPortsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/PutInstancePublicPorts
func (c *Client) PutInstancePublicPortsRequest(input *PutInstancePublicPortsInput) PutInstancePublicPortsRequest {
	op := &aws.Operation{
		Name:       opPutInstancePublicPorts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutInstancePublicPortsInput{}
	}

	req := c.newRequest(op, input, &PutInstancePublicPortsOutput{})
	return PutInstancePublicPortsRequest{Request: req, Input: input, Copy: c.PutInstancePublicPortsRequest}
}

// PutInstancePublicPortsRequest is the request type for the
// PutInstancePublicPorts API operation.
type PutInstancePublicPortsRequest struct {
	*aws.Request
	Input *PutInstancePublicPortsInput
	Copy  func(*PutInstancePublicPortsInput) PutInstancePublicPortsRequest
}

// Send marshals and sends the PutInstancePublicPorts API request.
func (r PutInstancePublicPortsRequest) Send(ctx context.Context) (*PutInstancePublicPortsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutInstancePublicPortsResponse{
		PutInstancePublicPortsOutput: r.Request.Data.(*PutInstancePublicPortsOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutInstancePublicPortsResponse is the response type for the
// PutInstancePublicPorts API operation.
type PutInstancePublicPortsResponse struct {
	*PutInstancePublicPortsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutInstancePublicPorts request.
func (r *PutInstancePublicPortsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
