// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPairRequest
type ImportKeyPairInput struct {
	_ struct{} `type:"structure"`

	// The name of the key pair for which you want to import the public key.
	//
	// KeyPairName is a required field
	KeyPairName *string `locationName:"keyPairName" type:"string" required:"true"`

	// A base64-encoded public key of the ssh-rsa type.
	//
	// PublicKeyBase64 is a required field
	PublicKeyBase64 *string `locationName:"publicKeyBase64" type:"string" required:"true"`
}

// String returns the string representation
func (s ImportKeyPairInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportKeyPairInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ImportKeyPairInput"}

	if s.KeyPairName == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyPairName"))
	}

	if s.PublicKeyBase64 == nil {
		invalidParams.Add(aws.NewErrParamRequired("PublicKeyBase64"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPairResult
type ImportKeyPairOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the request operation.
	Operation *Operation `locationName:"operation" type:"structure"`
}

// String returns the string representation
func (s ImportKeyPairOutput) String() string {
	return awsutil.Prettify(s)
}

const opImportKeyPair = "ImportKeyPair"

// ImportKeyPairRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Imports a public SSH key from a specific key pair.
//
//    // Example sending a request using ImportKeyPairRequest.
//    req := client.ImportKeyPairRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/ImportKeyPair
func (c *Client) ImportKeyPairRequest(input *ImportKeyPairInput) ImportKeyPairRequest {
	op := &aws.Operation{
		Name:       opImportKeyPair,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportKeyPairInput{}
	}

	req := c.newRequest(op, input, &ImportKeyPairOutput{})
	return ImportKeyPairRequest{Request: req, Input: input, Copy: c.ImportKeyPairRequest}
}

// ImportKeyPairRequest is the request type for the
// ImportKeyPair API operation.
type ImportKeyPairRequest struct {
	*aws.Request
	Input *ImportKeyPairInput
	Copy  func(*ImportKeyPairInput) ImportKeyPairRequest
}

// Send marshals and sends the ImportKeyPair API request.
func (r ImportKeyPairRequest) Send(ctx context.Context) (*ImportKeyPairResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ImportKeyPairResponse{
		ImportKeyPairOutput: r.Request.Data.(*ImportKeyPairOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ImportKeyPairResponse is the response type for the
// ImportKeyPair API operation.
type ImportKeyPairResponse struct {
	*ImportKeyPairOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ImportKeyPair request.
func (r *ImportKeyPairResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
