// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceRequest
type DeleteInstanceInput struct {
	_ struct{} `type:"structure"`

	// The name of the instance to delete.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteInstanceInput"}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstanceResult
type DeleteInstanceOutput struct {
	_ struct{} `type:"structure"`

	// An array of key-value pairs containing information about the results of your
	// delete instance request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteInstance = "DeleteInstance"

// DeleteInstanceRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Deletes a specific Amazon Lightsail virtual private server, or instance.
//
// The delete instance operation supports tag-based access control via resource
// tags applied to the resource identified by instanceName. For more information,
// see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using DeleteInstanceRequest.
//    req := client.DeleteInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteInstance
func (c *Client) DeleteInstanceRequest(input *DeleteInstanceInput) DeleteInstanceRequest {
	op := &aws.Operation{
		Name:       opDeleteInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInstanceInput{}
	}

	req := c.newRequest(op, input, &DeleteInstanceOutput{})
	return DeleteInstanceRequest{Request: req, Input: input, Copy: c.DeleteInstanceRequest}
}

// DeleteInstanceRequest is the request type for the
// DeleteInstance API operation.
type DeleteInstanceRequest struct {
	*aws.Request
	Input *DeleteInstanceInput
	Copy  func(*DeleteInstanceInput) DeleteInstanceRequest
}

// Send marshals and sends the DeleteInstance API request.
func (r DeleteInstanceRequest) Send(ctx context.Context) (*DeleteInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteInstanceResponse{
		DeleteInstanceOutput: r.Request.Data.(*DeleteInstanceOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteInstanceResponse is the response type for the
// DeleteInstance API operation.
type DeleteInstanceResponse struct {
	*DeleteInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteInstance request.
func (r *DeleteInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
