// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lexruntimeservice

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Represents an option to be shown on the client platform (Facebook, Slack,
// etc.)
// Please also see https://docs.aws.amazon.com/goto/WebAPI/runtime.lex-2016-11-28/Button
type Button struct {
	_ struct{} `type:"structure"`

	// Text that is visible to the user on the button.
	//
	// Text is a required field
	Text *string `locationName:"text" min:"1" type:"string" required:"true"`

	// The value sent to Amazon Lex when a user chooses the button. For example,
	// consider button text "NYC." When the user chooses the button, the value sent
	// can be "New York City."
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Button) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Button) MarshalFields(e protocol.FieldEncoder) error {
	if s.Text != nil {
		v := *s.Text

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "text", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents an option rendered to the user when a prompt is shown. It could
// be an image, a button, a link, or text.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/runtime.lex-2016-11-28/GenericAttachment
type GenericAttachment struct {
	_ struct{} `type:"structure"`

	// The URL of an attachment to the response card.
	AttachmentLinkUrl *string `locationName:"attachmentLinkUrl" min:"1" type:"string"`

	// The list of options to show to the user.
	Buttons []Button `locationName:"buttons" type:"list"`

	// The URL of an image that is displayed to the user.
	ImageUrl *string `locationName:"imageUrl" min:"1" type:"string"`

	// The subtitle shown below the title.
	SubTitle *string `locationName:"subTitle" min:"1" type:"string"`

	// The title of the option.
	Title *string `locationName:"title" min:"1" type:"string"`
}

// String returns the string representation
func (s GenericAttachment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GenericAttachment) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttachmentLinkUrl != nil {
		v := *s.AttachmentLinkUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attachmentLinkUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Buttons) > 0 {
		v := s.Buttons

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "buttons", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ImageUrl != nil {
		v := *s.ImageUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubTitle != nil {
		v := *s.SubTitle

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subTitle", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// If you configure a response card when creating your bots, Amazon Lex substitutes
// the session attributes and slot values that are available, and then returns
// it. The response card can also come from a Lambda function ( dialogCodeHook
// and fulfillmentActivity on an intent).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/runtime.lex-2016-11-28/ResponseCard
type ResponseCard struct {
	_ struct{} `type:"structure"`

	// The content type of the response.
	ContentType ContentType `locationName:"contentType" type:"string" enum:"true"`

	// An array of attachment objects representing options.
	GenericAttachments []GenericAttachment `locationName:"genericAttachments" type:"list"`

	// The version of the response card format.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ResponseCard) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResponseCard) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.ContentType) > 0 {
		v := s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "contentType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.GenericAttachments) > 0 {
		v := s.GenericAttachments

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "genericAttachments", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
