// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lambda

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayersRequest
type ListLayersInput struct {
	_ struct{} `type:"structure"`

	// A runtime identifier. For example, go1.x.
	CompatibleRuntime Runtime `location:"querystring" locationName:"CompatibleRuntime" type:"string" enum:"true"`

	// A pagination token returned by a previous call.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// The maximum number of layers to return.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`
}

// String returns the string representation
func (s ListLayersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLayersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListLayersInput"}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListLayersInput) MarshalFields(e protocol.FieldEncoder) error {

	if len(s.CompatibleRuntime) > 0 {
		v := s.CompatibleRuntime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "CompatibleRuntime", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MaxItems != nil {
		v := *s.MaxItems

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxItems", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayersResponse
type ListLayersOutput struct {
	_ struct{} `type:"structure"`

	// A list of function layers.
	Layers []LayersListItem `type:"list"`

	// A pagination token returned when the response doesn't contain all layers.
	NextMarker *string `type:"string"`
}

// String returns the string representation
func (s ListLayersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListLayersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Layers) > 0 {
		v := s.Layers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Layers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.NextMarker != nil {
		v := *s.NextMarker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextMarker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListLayers = "ListLayers"

// ListLayersRequest returns a request value for making API operation for
// AWS Lambda.
//
// Lists AWS Lambda layers (https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html)
// and shows information about the latest version of each. Specify a runtime
// identifier (https://docs.aws.amazon.com/lambda/latest/dg/lambda-runtimes.html)
// to list only layers that indicate that they're compatible with that runtime.
//
//    // Example sending a request using ListLayersRequest.
//    req := client.ListLayersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lambda-2015-03-31/ListLayers
func (c *Client) ListLayersRequest(input *ListLayersInput) ListLayersRequest {
	op := &aws.Operation{
		Name:       opListLayers,
		HTTPMethod: "GET",
		HTTPPath:   "/2018-10-31/layers",
	}

	if input == nil {
		input = &ListLayersInput{}
	}

	req := c.newRequest(op, input, &ListLayersOutput{})
	return ListLayersRequest{Request: req, Input: input, Copy: c.ListLayersRequest}
}

// ListLayersRequest is the request type for the
// ListLayers API operation.
type ListLayersRequest struct {
	*aws.Request
	Input *ListLayersInput
	Copy  func(*ListLayersInput) ListLayersRequest
}

// Send marshals and sends the ListLayers API request.
func (r ListLayersRequest) Send(ctx context.Context) (*ListLayersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListLayersResponse{
		ListLayersOutput: r.Request.Data.(*ListLayersOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListLayersResponse is the response type for the
// ListLayers API operation.
type ListLayersResponse struct {
	*ListLayersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListLayers request.
func (r *ListLayersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
