// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeysRequest
type ListKeysInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter to specify the maximum number of items to return. When
	// this value is present, AWS KMS does not return more than the specified number
	// of items, but it might return fewer.
	//
	// This value is optional. If you include a value, it must be between 1 and
	// 1000, inclusive. If you do not include a value, it defaults to 100.
	Limit *int64 `min:"1" type:"integer"`

	// Use this parameter in a subsequent request after you receive a response with
	// truncated results. Set it to the value of NextMarker from the truncated response
	// you just received.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListKeysInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListKeysInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListKeysInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeysResponse
type ListKeysOutput struct {
	_ struct{} `type:"structure"`

	// A list of customer master keys (CMKs).
	Keys []KeyListEntry `type:"list"`

	// When Truncated is true, this element is present and contains the value to
	// use for the Marker parameter in a subsequent request.
	NextMarker *string `min:"1" type:"string"`

	// A flag that indicates whether there are more items in the list. When this
	// value is true, the list in this response is truncated. To get more items,
	// pass the value of the NextMarker element in thisresponse to the Marker parameter
	// in a subsequent request.
	Truncated *bool `type:"boolean"`
}

// String returns the string representation
func (s ListKeysOutput) String() string {
	return awsutil.Prettify(s)
}

const opListKeys = "ListKeys"

// ListKeysRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Gets a list of all customer master keys (CMKs) in the caller's AWS account
// and region.
//
//    // Example sending a request using ListKeysRequest.
//    req := client.ListKeysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ListKeys
func (c *Client) ListKeysRequest(input *ListKeysInput) ListKeysRequest {
	op := &aws.Operation{
		Name:       opListKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "Limit",
			TruncationToken: "Truncated",
		},
	}

	if input == nil {
		input = &ListKeysInput{}
	}

	req := c.newRequest(op, input, &ListKeysOutput{})
	return ListKeysRequest{Request: req, Input: input, Copy: c.ListKeysRequest}
}

// ListKeysRequest is the request type for the
// ListKeys API operation.
type ListKeysRequest struct {
	*aws.Request
	Input *ListKeysInput
	Copy  func(*ListKeysInput) ListKeysRequest
}

// Send marshals and sends the ListKeys API request.
func (r ListKeysRequest) Send(ctx context.Context) (*ListKeysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListKeysResponse{
		ListKeysOutput: r.Request.Data.(*ListKeysOutput),
		response:       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListKeysRequestPaginator returns a paginator for ListKeys.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListKeysRequest(input)
//   p := kms.NewListKeysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListKeysPaginator(req ListKeysRequest) ListKeysPaginator {
	return ListKeysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListKeysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListKeysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListKeysPaginator struct {
	aws.Pager
}

func (p *ListKeysPaginator) CurrentPage() *ListKeysOutput {
	return p.Pager.CurrentPage().(*ListKeysOutput)
}

// ListKeysResponse is the response type for the
// ListKeys API operation.
type ListKeysResponse struct {
	*ListKeysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListKeys request.
func (r *ListKeysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
