// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKeyRequest
type CreateKeyInput struct {
	_ struct{} `type:"structure"`

	// A flag to indicate whether to bypass the key policy lockout safety check.
	//
	// Setting this value to true increases the risk that the CMK becomes unmanageable.
	// Do not set this value to true indiscriminately.
	//
	// For more information, refer to the scenario in the Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	// section in the AWS Key Management Service Developer Guide .
	//
	// Use this parameter only when you include a policy in the request and you
	// intend to prevent the principal that is making the request from making a
	// subsequent PutKeyPolicy request on the CMK.
	//
	// The default value is false.
	BypassPolicyLockoutSafetyCheck *bool `type:"boolean"`

	// Creates the CMK in the specified custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
	// and the key material in its associated AWS CloudHSM cluster. To create a
	// CMK in a custom key store, you must also specify the Origin parameter with
	// a value of AWS_CLOUDHSM. The AWS CloudHSM cluster that is associated with
	// the custom key store must have at least two active HSMs, each in a different
	// Availability Zone in the Region.
	//
	// To find the ID of a custom key store, use the DescribeCustomKeyStores operation.
	//
	// The response includes the custom key store ID and the ID of the AWS CloudHSM
	// cluster.
	//
	// This operation is part of the Custom Key Store feature (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
	// feature in AWS KMS, which combines the convenience and extensive integration
	// of AWS KMS with the isolation and control of a single-tenant key store.
	CustomKeyStoreId *string `min:"1" type:"string"`

	// A description of the CMK.
	//
	// Use a description that helps you decide whether the CMK is appropriate for
	// a task.
	Description *string `type:"string"`

	// The cryptographic operations for which you can use the CMK. The only valid
	// value is ENCRYPT_DECRYPT, which means you can use the CMK to encrypt and
	// decrypt data.
	KeyUsage KeyUsageType `type:"string" enum:"true"`

	// The source of the key material for the CMK. You cannot change the origin
	// after you create the CMK.
	//
	// The default is AWS_KMS, which means AWS KMS creates the key material in its
	// own key store.
	//
	// When the parameter value is EXTERNAL, AWS KMS creates a CMK without key material
	// so that you can import key material from your existing key management infrastructure.
	// For more information about importing key material into AWS KMS, see Importing
	// Key Material (https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
	// in the AWS Key Management Service Developer Guide.
	//
	// When the parameter value is AWS_CLOUDHSM, AWS KMS creates the CMK in an AWS
	// KMS custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
	// and creates its key material in the associated AWS CloudHSM cluster. You
	// must also use the CustomKeyStoreId parameter to identify the custom key store.
	Origin OriginType `type:"string" enum:"true"`

	// The key policy to attach to the CMK.
	//
	// If you provide a key policy, it must meet the following criteria:
	//
	//    * If you don't set BypassPolicyLockoutSafetyCheck to true, the key policy
	//    must allow the principal that is making the CreateKey request to make
	//    a subsequent PutKeyPolicy request on the CMK. This reduces the risk that
	//    the CMK becomes unmanageable. For more information, refer to the scenario
	//    in the Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
	//    section of the AWS Key Management Service Developer Guide .
	//
	//    * Each statement in the key policy must contain one or more principals.
	//    The principals in the key policy must exist and be visible to AWS KMS.
	//    When you create a new AWS principal (for example, an IAM user or role),
	//    you might need to enforce a delay before including the new principal in
	//    a key policy because the new principal might not be immediately visible
	//    to AWS KMS. For more information, see Changes that I make are not always
	//    immediately visible (https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
	//    in the AWS Identity and Access Management User Guide.
	//
	// If you do not provide a key policy, AWS KMS attaches a default key policy
	// to the CMK. For more information, see Default Key Policy (https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default)
	// in the AWS Key Management Service Developer Guide.
	//
	// The key policy size limit is 32 kilobytes (32768 bytes).
	Policy *string `min:"1" type:"string"`

	// One or more tags. Each tag consists of a tag key and a tag value. Tag keys
	// and tag values are both required, but tag values can be empty (null) strings.
	//
	// Use this parameter to tag the CMK when it is created. Alternately, you can
	// omit this parameter and instead tag the CMK after it is created using TagResource.
	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s CreateKeyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateKeyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateKeyInput"}
	if s.CustomKeyStoreId != nil && len(*s.CustomKeyStoreId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CustomKeyStoreId", 1))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Policy", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKeyResponse
type CreateKeyOutput struct {
	_ struct{} `type:"structure"`

	// Metadata associated with the CMK.
	KeyMetadata *KeyMetadata `type:"structure"`
}

// String returns the string representation
func (s CreateKeyOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateKey = "CreateKey"

// CreateKeyRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Creates a customer managed customer master key (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys)
// (CMK) in your AWS account.
//
// You can use a CMK to encrypt small amounts of data (up to 4096 bytes) directly.
// But CMKs are more commonly used to encrypt the data keys (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys)
// that are used to encrypt data.
//
// To create a CMK for imported key material, use the Origin parameter with
// a value of EXTERNAL.
//
// To create a CMK in a custom key store (https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html),
// use the CustomKeyStoreId parameter to specify the custom key store. You must
// also use the Origin parameter with a value of AWS_CLOUDHSM. The AWS CloudHSM
// cluster that is associated with the custom key store must have at least two
// active HSMs in different Availability Zones in the AWS Region.
//
// You cannot use this operation to create a CMK in a different AWS account.
//
//    // Example sending a request using CreateKeyRequest.
//    req := client.CreateKeyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/CreateKey
func (c *Client) CreateKeyRequest(input *CreateKeyInput) CreateKeyRequest {
	op := &aws.Operation{
		Name:       opCreateKey,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateKeyInput{}
	}

	req := c.newRequest(op, input, &CreateKeyOutput{})
	return CreateKeyRequest{Request: req, Input: input, Copy: c.CreateKeyRequest}
}

// CreateKeyRequest is the request type for the
// CreateKey API operation.
type CreateKeyRequest struct {
	*aws.Request
	Input *CreateKeyInput
	Copy  func(*CreateKeyInput) CreateKeyRequest
}

// Send marshals and sends the CreateKey API request.
func (r CreateKeyRequest) Send(ctx context.Context) (*CreateKeyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateKeyResponse{
		CreateKeyOutput: r.Request.Data.(*CreateKeyOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateKeyResponse is the response type for the
// CreateKey API operation.
type CreateKeyResponse struct {
	*CreateKeyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateKey request.
func (r *CreateKeyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
