// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalyticsv2

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Describes code configuration for a Java-based Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationCodeConfiguration
type ApplicationCodeConfiguration struct {
	_ struct{} `type:"structure"`

	// The location and type of the application code.
	CodeContent *CodeContent `type:"structure"`

	// Specifies whether the code content is in text or zip format.
	//
	// CodeContentType is a required field
	CodeContentType CodeContentType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ApplicationCodeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationCodeConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationCodeConfiguration"}
	if len(s.CodeContentType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("CodeContentType"))
	}
	if s.CodeContent != nil {
		if err := s.CodeContent.Validate(); err != nil {
			invalidParams.AddNested("CodeContent", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes code configuration for a Java-based Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationCodeConfigurationDescription
type ApplicationCodeConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes details about the location and format of the application code.
	CodeContentDescription *CodeContentDescription `type:"structure"`

	// Specifies whether the code content is in text or zip format.
	//
	// CodeContentType is a required field
	CodeContentType CodeContentType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ApplicationCodeConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to a Java-based Amazon Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationCodeConfigurationUpdate
type ApplicationCodeConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to the code content type.
	CodeContentTypeUpdate CodeContentType `type:"string" enum:"true"`

	// Describes updates to the code content of an application.
	CodeContentUpdate *CodeContentUpdate `type:"structure"`
}

// String returns the string representation
func (s ApplicationCodeConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationCodeConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationCodeConfigurationUpdate"}
	if s.CodeContentUpdate != nil {
		if err := s.CodeContentUpdate.Validate(); err != nil {
			invalidParams.AddNested("CodeContentUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies the creation parameters for an Amazon Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationConfiguration
type ApplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The code location and type parameters for a Java-based Kinesis Data Analytics
	// application.
	//
	// ApplicationCodeConfiguration is a required field
	ApplicationCodeConfiguration *ApplicationCodeConfiguration `type:"structure" required:"true"`

	// Describes whether snapshots are enabled for a Java-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfiguration *ApplicationSnapshotConfiguration `type:"structure"`

	// Describes execution properties for a Java-based Kinesis Data Analytics application.
	EnvironmentProperties *EnvironmentProperties `type:"structure"`

	// The creation and update parameters for a Java-based Kinesis Data Analytics
	// application.
	FlinkApplicationConfiguration *FlinkApplicationConfiguration `type:"structure"`

	// The creation and update parameters for an SQL-based Kinesis Data Analytics
	// application.
	SqlApplicationConfiguration *SqlApplicationConfiguration `type:"structure"`
}

// String returns the string representation
func (s ApplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationConfiguration"}

	if s.ApplicationCodeConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationCodeConfiguration"))
	}
	if s.ApplicationCodeConfiguration != nil {
		if err := s.ApplicationCodeConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationCodeConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.ApplicationSnapshotConfiguration != nil {
		if err := s.ApplicationSnapshotConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSnapshotConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.EnvironmentProperties != nil {
		if err := s.EnvironmentProperties.Validate(); err != nil {
			invalidParams.AddNested("EnvironmentProperties", err.(aws.ErrInvalidParams))
		}
	}
	if s.FlinkApplicationConfiguration != nil {
		if err := s.FlinkApplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("FlinkApplicationConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.SqlApplicationConfiguration != nil {
		if err := s.SqlApplicationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SqlApplicationConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes details about the application code and starting parameters for
// an Amazon Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationConfigurationDescription
type ApplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The details about the application code for a Java-based Kinesis Data Analytics
	// application.
	ApplicationCodeConfigurationDescription *ApplicationCodeConfigurationDescription `type:"structure"`

	// Describes whether snapshots are enabled for a Java-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfigurationDescription *ApplicationSnapshotConfigurationDescription `type:"structure"`

	// Describes execution properties for a Java-based Kinesis Data Analytics application.
	EnvironmentPropertyDescriptions *EnvironmentPropertyDescriptions `type:"structure"`

	// The details about a Java-based Kinesis Data Analytics application.
	FlinkApplicationConfigurationDescription *FlinkApplicationConfigurationDescription `type:"structure"`

	// The details about the starting properties for a Kinesis Data Analytics application.
	RunConfigurationDescription *RunConfigurationDescription `type:"structure"`

	// The details about inputs, outputs, and reference data sources for an SQL-based
	// Kinesis Data Analytics application.
	SqlApplicationConfigurationDescription *SqlApplicationConfigurationDescription `type:"structure"`
}

// String returns the string representation
func (s ApplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to an application's configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationConfigurationUpdate
type ApplicationConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to a Java-based Kinesis Data Analytics application's code
	// configuration.
	ApplicationCodeConfigurationUpdate *ApplicationCodeConfigurationUpdate `type:"structure"`

	// Describes whether snapshots are enabled for a Java-based Kinesis Data Analytics
	// application.
	ApplicationSnapshotConfigurationUpdate *ApplicationSnapshotConfigurationUpdate `type:"structure"`

	// Describes updates to the environment properties for a Java-based Kinesis
	// Data Analytics application.
	EnvironmentPropertyUpdates *EnvironmentPropertyUpdates `type:"structure"`

	// Describes updates to a Java-based Kinesis Data Analytics application's configuration.
	FlinkApplicationConfigurationUpdate *FlinkApplicationConfigurationUpdate `type:"structure"`

	// Describes updates to an SQL-based Kinesis Data Analytics application's configuration.
	SqlApplicationConfigurationUpdate *SqlApplicationConfigurationUpdate `type:"structure"`
}

// String returns the string representation
func (s ApplicationConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationConfigurationUpdate"}
	if s.ApplicationCodeConfigurationUpdate != nil {
		if err := s.ApplicationCodeConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ApplicationCodeConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.ApplicationSnapshotConfigurationUpdate != nil {
		if err := s.ApplicationSnapshotConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ApplicationSnapshotConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.EnvironmentPropertyUpdates != nil {
		if err := s.EnvironmentPropertyUpdates.Validate(); err != nil {
			invalidParams.AddNested("EnvironmentPropertyUpdates", err.(aws.ErrInvalidParams))
		}
	}
	if s.FlinkApplicationConfigurationUpdate != nil {
		if err := s.FlinkApplicationConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("FlinkApplicationConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.SqlApplicationConfigurationUpdate != nil {
		if err := s.SqlApplicationConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("SqlApplicationConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the application, including the application Amazon Resource Name
// (ARN), status, latest version, and input and output configurations.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationDetail
type ApplicationDetail struct {
	_ struct{} `type:"structure"`

	// The ARN of the application.
	//
	// ApplicationARN is a required field
	ApplicationARN *string `min:"1" type:"string" required:"true"`

	// Provides details about the application's SQL or Java code and starting parameters.
	ApplicationConfigurationDescription *ApplicationConfigurationDescription `type:"structure"`

	// The description of the application.
	ApplicationDescription *string `type:"string"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus ApplicationStatus `type:"string" required:"true" enum:"true"`

	// Provides the current application version. Kinesis Data Analytics updates
	// the ApplicationVersionId each time you update the application.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// Describes the application Amazon CloudWatch logging options.
	CloudWatchLoggingOptionDescriptions []CloudWatchLoggingOptionDescription `type:"list"`

	// The current timestamp when the application was created.
	CreateTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The current timestamp when the application was last updated.
	LastUpdateTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The runtime environment for the application (SQL-1.0 or FLINK-1_6).
	//
	// RuntimeEnvironment is a required field
	RuntimeEnvironment RuntimeEnvironment `type:"string" required:"true" enum:"true"`

	// Specifies the IAM role that the application uses to access external resources.
	ServiceExecutionRole *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ApplicationDetail) String() string {
	return awsutil.Prettify(s)
}

// Specifies the method and snapshot to use when restarting an application using
// previously saved application state.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationRestoreConfiguration
type ApplicationRestoreConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies how the application should be restored.
	//
	// ApplicationRestoreType is a required field
	ApplicationRestoreType ApplicationRestoreType `type:"string" required:"true" enum:"true"`

	// The identifier of an existing snapshot of application state to use to restart
	// an application. The application uses this value if RESTORE_FROM_CUSTOM_SNAPSHOT
	// is specified for the ApplicationRestoreType.
	SnapshotName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ApplicationRestoreConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationRestoreConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationRestoreConfiguration"}
	if len(s.ApplicationRestoreType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationRestoreType"))
	}
	if s.SnapshotName != nil && len(*s.SnapshotName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SnapshotName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes whether snapshots are enabled for a Java-based Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationSnapshotConfiguration
type ApplicationSnapshotConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes whether snapshots are enabled for a Java-based Kinesis Data Analytics
	// application.
	//
	// SnapshotsEnabled is a required field
	SnapshotsEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ApplicationSnapshotConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSnapshotConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationSnapshotConfiguration"}

	if s.SnapshotsEnabled == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotsEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes whether snapshots are enabled for a Java-based Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationSnapshotConfigurationDescription
type ApplicationSnapshotConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes whether snapshots are enabled for a Java-based Kinesis Data Analytics
	// application.
	//
	// SnapshotsEnabled is a required field
	SnapshotsEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ApplicationSnapshotConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to whether snapshots are enabled for a Java-based Kinesis
// Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationSnapshotConfigurationUpdate
type ApplicationSnapshotConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to whether snapshots are enabled for a Java-based Kinesis
	// Data Analytics application.
	//
	// SnapshotsEnabledUpdate is a required field
	SnapshotsEnabledUpdate *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s ApplicationSnapshotConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplicationSnapshotConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ApplicationSnapshotConfigurationUpdate"}

	if s.SnapshotsEnabledUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotsEnabledUpdate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides application summary information, including the application Amazon
// Resource Name (ARN), name, and status.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ApplicationSummary
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The ARN of the application.
	//
	// ApplicationARN is a required field
	ApplicationARN *string `min:"1" type:"string" required:"true"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The status of the application.
	//
	// ApplicationStatus is a required field
	ApplicationStatus ApplicationStatus `type:"string" required:"true" enum:"true"`

	// Provides the current application version.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The runtime environment for the application (SQL-1.0 or FLINK-1_6).
	//
	// RuntimeEnvironment is a required field
	RuntimeEnvironment RuntimeEnvironment `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based application, provides additional mapping information when
// the record format uses delimiters, such as CSV. For example, the following
// sample records use CSV format, where the records use the '\n' as the row
// delimiter and a comma (",") as the column delimiter:
//
// "name1", "address1"
//
// "name2", "address2"
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CSVMappingParameters
type CSVMappingParameters struct {
	_ struct{} `type:"structure"`

	// The column delimiter. For example, in a CSV format, a comma (",") is the
	// typical column delimiter.
	//
	// RecordColumnDelimiter is a required field
	RecordColumnDelimiter *string `min:"1" type:"string" required:"true"`

	// The row delimiter. For example, in a CSV format, '\n' is the typical row
	// delimiter.
	//
	// RecordRowDelimiter is a required field
	RecordRowDelimiter *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CSVMappingParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CSVMappingParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CSVMappingParameters"}

	if s.RecordColumnDelimiter == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordColumnDelimiter"))
	}
	if s.RecordColumnDelimiter != nil && len(*s.RecordColumnDelimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordColumnDelimiter", 1))
	}

	if s.RecordRowDelimiter == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordRowDelimiter"))
	}
	if s.RecordRowDelimiter != nil && len(*s.RecordRowDelimiter) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordRowDelimiter", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an application's checkpointing configuration. Checkpointing is
// the process of persisting application state for fault tolerance. For more
// information, see Checkpoints for Fault Tolerance (https://ci.apache.org/projects/flink/flink-docs-release-1.6/concepts/programming-model.html#checkpoints-for-fault-tolerance)
// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.6/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CheckpointConfiguration
type CheckpointConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes the interval in milliseconds between checkpoint operations.
	CheckpointInterval *int64 `type:"long"`

	// Describes whether checkpointing is enabled for a Java-based Kinesis Data
	// Analytics application.
	CheckpointingEnabled *bool `type:"boolean"`

	// Describes whether the application uses Amazon Kinesis Data Analytics' default
	// checkpointing behavior.
	//
	// ConfigurationType is a required field
	ConfigurationType ConfigurationType `type:"string" required:"true" enum:"true"`

	// Describes the minimum time in milliseconds after a checkpoint operation completes
	// that a new checkpoint operation can start. If a checkpoint operation takes
	// longer than the CheckpointInterval, the application otherwise performs continual
	// checkpoint operations. For more information, see Tuning Checkpointing (https://ci.apache.org/projects/flink/flink-docs-stable/ops/state/large_state_tuning.html#tuning-checkpointing)
	// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.6/).
	MinPauseBetweenCheckpoints *int64 `type:"long"`
}

// String returns the string representation
func (s CheckpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CheckpointConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CheckpointConfiguration"}
	if len(s.ConfigurationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes checkpointing parameters for a Java-based Amazon Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CheckpointConfigurationDescription
type CheckpointConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes the interval in milliseconds between checkpoint operations.
	CheckpointInterval *int64 `type:"long"`

	// Describes whether checkpointing is enabled for a Java-based Kinesis Data
	// Analytics application.
	CheckpointingEnabled *bool `type:"boolean"`

	// Describes whether the application uses the default checkpointing behavior
	// in Kinesis Data Analytics.
	ConfigurationType ConfigurationType `type:"string" enum:"true"`

	// Describes the minimum time in milliseconds after a checkpoint operation completes
	// that a new checkpoint operation can start.
	MinPauseBetweenCheckpoints *int64 `type:"long"`
}

// String returns the string representation
func (s CheckpointConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to the checkpointing parameters for a Java-based Amazon
// Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CheckpointConfigurationUpdate
type CheckpointConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to the interval in milliseconds between checkpoint operations.
	CheckpointIntervalUpdate *int64 `type:"long"`

	// Describes updates to whether checkpointing is enabled for an application.
	CheckpointingEnabledUpdate *bool `type:"boolean"`

	// Describes updates to whether the application uses the default checkpointing
	// behavior of Kinesis Data Analytics.
	ConfigurationTypeUpdate ConfigurationType `type:"string" enum:"true"`

	// Describes updates to the minimum time in milliseconds after a checkpoint
	// operation completes that a new checkpoint operation can start.
	MinPauseBetweenCheckpointsUpdate *int64 `type:"long"`
}

// String returns the string representation
func (s CheckpointConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Provides a description of Amazon CloudWatch logging options, including the
// log stream Amazon Resource Name (ARN).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CloudWatchLoggingOption
type CloudWatchLoggingOption struct {
	_ struct{} `type:"structure"`

	// The ARN of the CloudWatch log to receive application messages.
	//
	// LogStreamARN is a required field
	LogStreamARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CloudWatchLoggingOption) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLoggingOption) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchLoggingOption"}

	if s.LogStreamARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("LogStreamARN"))
	}
	if s.LogStreamARN != nil && len(*s.LogStreamARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the Amazon CloudWatch logging option.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CloudWatchLoggingOptionDescription
type CloudWatchLoggingOptionDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the CloudWatch logging option description.
	CloudWatchLoggingOptionId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the CloudWatch log to receive application
	// messages.
	//
	// LogStreamARN is a required field
	LogStreamARN *string `min:"1" type:"string" required:"true"`

	// The IAM ARN of the role to use to send application messages.
	//
	// Provided for backward compatibility. Applications created with the current
	// API version have an application-level service execution role rather than
	// a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CloudWatchLoggingOptionDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes the Amazon CloudWatch logging option updates.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CloudWatchLoggingOptionUpdate
type CloudWatchLoggingOptionUpdate struct {
	_ struct{} `type:"structure"`

	// The ID of the CloudWatch logging option to update
	//
	// CloudWatchLoggingOptionId is a required field
	CloudWatchLoggingOptionId *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the CloudWatch log to receive application
	// messages.
	LogStreamARNUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CloudWatchLoggingOptionUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudWatchLoggingOptionUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CloudWatchLoggingOptionUpdate"}

	if s.CloudWatchLoggingOptionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CloudWatchLoggingOptionId"))
	}
	if s.CloudWatchLoggingOptionId != nil && len(*s.CloudWatchLoggingOptionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CloudWatchLoggingOptionId", 1))
	}
	if s.LogStreamARNUpdate != nil && len(*s.LogStreamARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LogStreamARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Specifies either the application code, or the location of the application
// code, for a Java-based Amazon Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CodeContent
type CodeContent struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon S3 bucket containing the application code.
	S3ContentLocation *S3ContentLocation `type:"structure"`

	// The text-format code for a Java-based Kinesis Data Analytics application.
	TextContent *string `type:"string"`

	// The zip-format code for a Java-based Kinesis Data Analytics application.
	//
	// ZipFileContent is automatically base64 encoded/decoded by the SDK.
	ZipFileContent []byte `type:"blob"`
}

// String returns the string representation
func (s CodeContent) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeContent) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeContent"}
	if s.S3ContentLocation != nil {
		if err := s.S3ContentLocation.Validate(); err != nil {
			invalidParams.AddNested("S3ContentLocation", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes details about the application code for a Java-based Kinesis Data
// Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CodeContentDescription
type CodeContentDescription struct {
	_ struct{} `type:"structure"`

	// The checksum that can be used to validate zip-format code.
	CodeMD5 *string `min:"128" type:"string"`

	// The size in bytes of the application code. Can be used to validate zip-format
	// code.
	CodeSize *int64 `type:"long"`

	// The S3 bucket Amazon Resource Name (ARN), file key, and object version of
	// the application code stored in Amazon S3.
	S3ApplicationCodeLocationDescription *S3ApplicationCodeLocationDescription `type:"structure"`

	// The text-format code
	TextContent *string `type:"string"`
}

// String returns the string representation
func (s CodeContentDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes an update to the code of a Java-based Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CodeContentUpdate
type CodeContentUpdate struct {
	_ struct{} `type:"structure"`

	// Describes an update to the location of code for an application.
	S3ContentLocationUpdate *S3ContentLocationUpdate `type:"structure"`

	// Describes an update to the text code for an application.
	TextContentUpdate *string `type:"string"`

	// Describes an update to the zipped code for an application.
	//
	// ZipFileContentUpdate is automatically base64 encoded/decoded by the SDK.
	ZipFileContentUpdate []byte `type:"blob"`
}

// String returns the string representation
func (s CodeContentUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CodeContentUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CodeContentUpdate"}
	if s.S3ContentLocationUpdate != nil {
		if err := s.S3ContentLocationUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3ContentLocationUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the data format when records are written to the destination in
// an SQL-based Amazon Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/DestinationSchema
type DestinationSchema struct {
	_ struct{} `type:"structure"`

	// Specifies the format of the records on the output stream.
	//
	// RecordFormatType is a required field
	RecordFormatType RecordFormatType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s DestinationSchema) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DestinationSchema) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DestinationSchema"}
	if len(s.RecordFormatType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RecordFormatType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes execution properties for a Java-based Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/EnvironmentProperties
type EnvironmentProperties struct {
	_ struct{} `type:"structure"`

	// Describes the execution property groups.
	//
	// PropertyGroups is a required field
	PropertyGroups []PropertyGroup `type:"list" required:"true"`
}

// String returns the string representation
func (s EnvironmentProperties) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentProperties) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnvironmentProperties"}

	if s.PropertyGroups == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyGroups"))
	}
	if s.PropertyGroups != nil {
		for i, v := range s.PropertyGroups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyGroups", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the execution properties for a Java-based Amazon Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/EnvironmentPropertyDescriptions
type EnvironmentPropertyDescriptions struct {
	_ struct{} `type:"structure"`

	// Describes the execution property groups.
	PropertyGroupDescriptions []PropertyGroup `type:"list"`
}

// String returns the string representation
func (s EnvironmentPropertyDescriptions) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to the execution property groups for a Java-based Amazon
// Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/EnvironmentPropertyUpdates
type EnvironmentPropertyUpdates struct {
	_ struct{} `type:"structure"`

	// Describes updates to the execution property groups.
	//
	// PropertyGroups is a required field
	PropertyGroups []PropertyGroup `type:"list" required:"true"`
}

// String returns the string representation
func (s EnvironmentPropertyUpdates) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentPropertyUpdates) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EnvironmentPropertyUpdates"}

	if s.PropertyGroups == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyGroups"))
	}
	if s.PropertyGroups != nil {
		for i, v := range s.PropertyGroups {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PropertyGroups", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes configuration parameters for a Java-based Amazon Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/FlinkApplicationConfiguration
type FlinkApplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes an application's checkpointing configuration. Checkpointing is
	// the process of persisting application state for fault tolerance. For more
	// information, see Checkpoints for Fault Tolerance (https://ci.apache.org/projects/flink/flink-docs-release-1.6/concepts/programming-model.html#checkpoints-for-fault-tolerance)
	// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.6/).
	CheckpointConfiguration *CheckpointConfiguration `type:"structure"`

	// Describes configuration parameters for Amazon CloudWatch logging for an application.
	MonitoringConfiguration *MonitoringConfiguration `type:"structure"`

	// Describes parameters for how an application executes multiple tasks simultaneously.
	ParallelismConfiguration *ParallelismConfiguration `type:"structure"`
}

// String returns the string representation
func (s FlinkApplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlinkApplicationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FlinkApplicationConfiguration"}
	if s.CheckpointConfiguration != nil {
		if err := s.CheckpointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("CheckpointConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.MonitoringConfiguration != nil {
		if err := s.MonitoringConfiguration.Validate(); err != nil {
			invalidParams.AddNested("MonitoringConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.ParallelismConfiguration != nil {
		if err := s.ParallelismConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ParallelismConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes configuration parameters for a Java-based Amazon Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/FlinkApplicationConfigurationDescription
type FlinkApplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes an application's checkpointing configuration. Checkpointing is
	// the process of persisting application state for fault tolerance.
	CheckpointConfigurationDescription *CheckpointConfigurationDescription `type:"structure"`

	// The job plan for an application. For more information about the job plan,
	// see Jobs and Scheduling (https://ci.apache.org/projects/flink/flink-docs-stable/internals/job_scheduling.html)
	// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.6/).
	// To retrieve the job plan for the application, use the DescribeApplicationRequest$IncludeAdditionalDetails
	// parameter of the DescribeApplication operation.
	JobPlanDescription *string `type:"string"`

	// Describes configuration parameters for Amazon CloudWatch logging for an application.
	MonitoringConfigurationDescription *MonitoringConfigurationDescription `type:"structure"`

	// Describes parameters for how an application executes multiple tasks simultaneously.
	ParallelismConfigurationDescription *ParallelismConfigurationDescription `type:"structure"`
}

// String returns the string representation
func (s FlinkApplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to the configuration parameters for a Java-based Amazon
// Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/FlinkApplicationConfigurationUpdate
type FlinkApplicationConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to an application's checkpointing configuration. Checkpointing
	// is the process of persisting application state for fault tolerance.
	CheckpointConfigurationUpdate *CheckpointConfigurationUpdate `type:"structure"`

	// Describes updates to the configuration parameters for Amazon CloudWatch logging
	// for an application.
	MonitoringConfigurationUpdate *MonitoringConfigurationUpdate `type:"structure"`

	// Describes updates to the parameters for how an application executes multiple
	// tasks simultaneously.
	ParallelismConfigurationUpdate *ParallelismConfigurationUpdate `type:"structure"`
}

// String returns the string representation
func (s FlinkApplicationConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlinkApplicationConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FlinkApplicationConfigurationUpdate"}
	if s.ParallelismConfigurationUpdate != nil {
		if err := s.ParallelismConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ParallelismConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When you configure the application input for an SQL-based Amazon Kinesis
// Data Analytics application, you specify the streaming source, the in-application
// stream name that is created, and the mapping between the two.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/Input
type Input struct {
	_ struct{} `type:"structure"`

	// Describes the number of in-application streams to create.
	InputParallelism *InputParallelism `type:"structure"`

	// The InputProcessingConfiguration for the input. An input processor transforms
	// records as they are received from the stream, before the application's SQL
	// code executes. Currently, the only input processing configuration available
	// is InputLambdaProcessor.
	InputProcessingConfiguration *InputProcessingConfiguration `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is
	// being created.
	//
	// Also used to describe the format of the reference data source.
	//
	// InputSchema is a required field
	InputSchema *SourceSchema `type:"structure" required:"true"`

	// If the streaming source is an Amazon Kinesis Data Firehose delivery stream,
	// identifies the delivery stream's ARN.
	KinesisFirehoseInput *KinesisFirehoseInput `type:"structure"`

	// If the streaming source is an Amazon Kinesis data stream, identifies the
	// stream's Amazon Resource Name (ARN).
	KinesisStreamsInput *KinesisStreamsInput `type:"structure"`

	// The name prefix to use when creating an in-application stream. Suppose that
	// you specify a prefix "MyInApplicationStream." Kinesis Data Analytics then
	// creates one or more (as per the InputParallelism count you specified) in-application
	// streams with the names "MyInApplicationStream_001," "MyInApplicationStream_002,"
	// and so on.
	//
	// NamePrefix is a required field
	NamePrefix *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Input) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Input) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Input"}

	if s.InputSchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputSchema"))
	}

	if s.NamePrefix == nil {
		invalidParams.Add(aws.NewErrParamRequired("NamePrefix"))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.InputParallelism != nil {
		if err := s.InputParallelism.Validate(); err != nil {
			invalidParams.AddNested("InputParallelism", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputProcessingConfiguration != nil {
		if err := s.InputProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputSchema != nil {
		if err := s.InputSchema.Validate(); err != nil {
			invalidParams.AddNested("InputSchema", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseInput != nil {
		if err := s.KinesisFirehoseInput.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseInput", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsInput != nil {
		if err := s.KinesisStreamsInput.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsInput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the application input configuration for an SQL-based Amazon Kinesis
// Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputDescription
type InputDescription struct {
	_ struct{} `type:"structure"`

	// Returns the in-application stream names that are mapped to the stream source.
	InAppStreamNames []string `type:"list"`

	// The input ID that is associated with the application input. This is the ID
	// that Kinesis Data Analytics assigns to each input configuration that you
	// add to your application.
	InputId *string `min:"1" type:"string"`

	// Describes the configured parallelism (number of in-application streams mapped
	// to the streaming source).
	InputParallelism *InputParallelism `type:"structure"`

	// The description of the preprocessor that executes on records in this input
	// before the application's code is run.
	InputProcessingConfigurationDescription *InputProcessingConfigurationDescription `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns in the in-application stream that is
	// being created.
	InputSchema *SourceSchema `type:"structure"`

	// The point at which the application is configured to read from the input stream.
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure"`

	// If a Kinesis Data Firehose delivery stream is configured as a streaming source,
	// provides the delivery stream's ARN.
	KinesisFirehoseInputDescription *KinesisFirehoseInputDescription `type:"structure"`

	// If a Kinesis data stream is configured as a streaming source, provides the
	// Kinesis data stream's Amazon Resource Name (ARN).
	KinesisStreamsInputDescription *KinesisStreamsInputDescription `type:"structure"`

	// The in-application name prefix.
	NamePrefix *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputDescription) String() string {
	return awsutil.Prettify(s)
}

// An object that contains the Amazon Resource Name (ARN) of the AWS Lambda
// function that is used to preprocess records in the stream in an SQL-based
// Amazon Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputLambdaProcessor
type InputLambdaProcessor struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Lambda function that operates on records in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InputLambdaProcessor) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLambdaProcessor) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputLambdaProcessor"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, an object that
// contains the Amazon Resource Name (ARN) of the AWS Lambda function that is
// used to preprocess records in the stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputLambdaProcessorDescription
type InputLambdaProcessorDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the AWS Lambda function that is used to preprocess the records
	// in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that is used to access the AWS Lambda function.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputLambdaProcessorDescription) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, represents an
// update to the InputLambdaProcessor that is used to preprocess the records
// in the stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputLambdaProcessorUpdate
type InputLambdaProcessorUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new AWS Lambda function that is used
	// to preprocess the records in the stream.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InputLambdaProcessorUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputLambdaProcessorUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputLambdaProcessorUpdate"}

	if s.ResourceARNUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// number of in-application streams to create for a given streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputParallelism
type InputParallelism struct {
	_ struct{} `type:"structure"`

	// The number of in-application streams to create.
	Count *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s InputParallelism) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputParallelism) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputParallelism"}
	if s.Count != nil && *s.Count < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Count", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, provides updates
// to the parallelism count.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputParallelismUpdate
type InputParallelismUpdate struct {
	_ struct{} `type:"structure"`

	// The number of in-application streams to create for the specified streaming
	// source.
	//
	// CountUpdate is a required field
	CountUpdate *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s InputParallelismUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputParallelismUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputParallelismUpdate"}

	if s.CountUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("CountUpdate"))
	}
	if s.CountUpdate != nil && *s.CountUpdate < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("CountUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes a processor
// that is used to preprocess the records in the stream before being processed
// by your application code. Currently, the only input processor available is
// AWS Lambda (https://aws.amazon.com/documentation/lambda/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputProcessingConfiguration
type InputProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// The InputLambdaProcessor that is used to preprocess the records in the stream
	// before being processed by your application code.
	//
	// InputLambdaProcessor is a required field
	InputLambdaProcessor *InputLambdaProcessor `type:"structure" required:"true"`
}

// String returns the string representation
func (s InputProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputProcessingConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputProcessingConfiguration"}

	if s.InputLambdaProcessor == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputLambdaProcessor"))
	}
	if s.InputLambdaProcessor != nil {
		if err := s.InputLambdaProcessor.Validate(); err != nil {
			invalidParams.AddNested("InputLambdaProcessor", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, provides the
// configuration information about an input processor. Currently, the only input
// processor available is AWS Lambda (https://aws.amazon.com/documentation/lambda/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputProcessingConfigurationDescription
type InputProcessingConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Provides configuration information about the associated InputLambdaProcessorDescription
	InputLambdaProcessorDescription *InputLambdaProcessorDescription `type:"structure"`
}

// String returns the string representation
func (s InputProcessingConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes updates
// to an InputProcessingConfiguration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputProcessingConfigurationUpdate
type InputProcessingConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Provides update information for an InputLambdaProcessor.
	//
	// InputLambdaProcessorUpdate is a required field
	InputLambdaProcessorUpdate *InputLambdaProcessorUpdate `type:"structure" required:"true"`
}

// String returns the string representation
func (s InputProcessingConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputProcessingConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputProcessingConfigurationUpdate"}

	if s.InputLambdaProcessorUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputLambdaProcessorUpdate"))
	}
	if s.InputLambdaProcessorUpdate != nil {
		if err := s.InputLambdaProcessorUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputLambdaProcessorUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes updates for an SQL-based Amazon Kinesis Data Analytics application's
// input schema.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputSchemaUpdate
type InputSchemaUpdate struct {
	_ struct{} `type:"structure"`

	// A list of RecordColumn objects. Each object describes the mapping of the
	// streaming source element to the corresponding column in the in-application
	// stream.
	RecordColumnUpdates []RecordColumn `min:"1" type:"list"`

	// Specifies the encoding of the records in the streaming source; for example,
	// UTF-8.
	RecordEncodingUpdate *string `type:"string"`

	// Specifies the format of the records on the streaming source.
	RecordFormatUpdate *RecordFormat `type:"structure"`
}

// String returns the string representation
func (s InputSchemaUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputSchemaUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputSchemaUpdate"}
	if s.RecordColumnUpdates != nil && len(s.RecordColumnUpdates) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordColumnUpdates", 1))
	}
	if s.RecordColumnUpdates != nil {
		for i, v := range s.RecordColumnUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordColumnUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RecordFormatUpdate != nil {
		if err := s.RecordFormatUpdate.Validate(); err != nil {
			invalidParams.AddNested("RecordFormatUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the point at which the application reads from the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputStartingPositionConfiguration
type InputStartingPositionConfiguration struct {
	_ struct{} `type:"structure"`

	// The starting position on the stream.
	//
	//    * NOW - Start reading just after the most recent record in the stream,
	//    and start at the request timestamp that the customer issued.
	//
	//    * TRIM_HORIZON - Start reading at the last untrimmed record in the stream,
	//    which is the oldest record available in the stream. This option is not
	//    available for an Amazon Kinesis Data Firehose delivery stream.
	//
	//    * LAST_STOPPED_POINT - Resume reading from where the application last
	//    stopped reading.
	InputStartingPosition InputStartingPosition `type:"string" enum:"true"`
}

// String returns the string representation
func (s InputStartingPositionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes updates
// to a specific input configuration (identified by the InputId of an application).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/InputUpdate
type InputUpdate struct {
	_ struct{} `type:"structure"`

	// The input ID of the application input to be updated.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`

	// Describes the parallelism updates (the number of in-application streams Kinesis
	// Data Analytics creates for the specific streaming source).
	InputParallelismUpdate *InputParallelismUpdate `type:"structure"`

	// Describes updates to an InputProcessingConfiguration.
	InputProcessingConfigurationUpdate *InputProcessingConfigurationUpdate `type:"structure"`

	// Describes the data format on the streaming source, and how record elements
	// on the streaming source map to columns of the in-application stream that
	// is created.
	InputSchemaUpdate *InputSchemaUpdate `type:"structure"`

	// If a Kinesis Data Firehose delivery stream is the streaming source to be
	// updated, provides an updated stream ARN.
	KinesisFirehoseInputUpdate *KinesisFirehoseInputUpdate `type:"structure"`

	// If a Kinesis data stream is the streaming source to be updated, provides
	// an updated stream Amazon Resource Name (ARN).
	KinesisStreamsInputUpdate *KinesisStreamsInputUpdate `type:"structure"`

	// The name prefix for in-application streams that Kinesis Data Analytics creates
	// for the specific streaming source.
	NamePrefixUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InputUpdate"}

	if s.InputId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputId", 1))
	}
	if s.NamePrefixUpdate != nil && len(*s.NamePrefixUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NamePrefixUpdate", 1))
	}
	if s.InputParallelismUpdate != nil {
		if err := s.InputParallelismUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputParallelismUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputProcessingConfigurationUpdate != nil {
		if err := s.InputProcessingConfigurationUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputProcessingConfigurationUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.InputSchemaUpdate != nil {
		if err := s.InputSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("InputSchemaUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseInputUpdate != nil {
		if err := s.KinesisFirehoseInputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseInputUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsInputUpdate != nil {
		if err := s.KinesisStreamsInputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsInputUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, provides additional
// mapping information when JSON is the record format on the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/JSONMappingParameters
type JSONMappingParameters struct {
	_ struct{} `type:"structure"`

	// The path to the top-level parent that contains the records.
	//
	// RecordRowPath is a required field
	RecordRowPath *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s JSONMappingParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JSONMappingParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "JSONMappingParameters"}

	if s.RecordRowPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordRowPath"))
	}
	if s.RecordRowPath != nil && len(*s.RecordRowPath) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordRowPath", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, identifies a
// Kinesis Data Firehose delivery stream as the streaming source. You provide
// the delivery stream's Amazon Resource Name (ARN).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisFirehoseInput
type KinesisFirehoseInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseInput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the Amazon Kinesis Data Firehose delivery stream that is configured
// as the streaming source in the application input configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisFirehoseInputDescription
type KinesisFirehoseInputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics assumes to access the
	// stream.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseInputDescription) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, when updating
// application input configuration, provides information about a Kinesis Data
// Firehose delivery stream as the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisFirehoseInputUpdate
type KinesisFirehoseInputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the input delivery stream to read.
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseInputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseInputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseInputUpdate"}

	if s.ResourceARNUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, when configuring
// application output, identifies a Kinesis Data Firehose delivery stream as
// the destination. You provide the stream Amazon Resource Name (ARN) of the
// delivery stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisFirehoseOutput
type KinesisFirehoseOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the destination delivery stream to write to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseOutput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application's output, describes
// the Kinesis Data Firehose delivery stream that is configured as its destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisFirehoseOutputDescription
type KinesisFirehoseOutputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access
	// the stream.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisFirehoseOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, when updating
// an output configuration using the UpdateApplication operation, provides information
// about a Kinesis Data Firehose delivery stream that is configured as the destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisFirehoseOutputUpdate
type KinesisFirehoseOutputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the delivery stream to write to.
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisFirehoseOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisFirehoseOutputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisFirehoseOutputUpdate"}

	if s.ResourceARNUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Identifies an Amazon Kinesis data stream as the streaming source. You provide
// the stream's Amazon Resource Name (ARN).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisStreamsInput
type KinesisStreamsInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the input Kinesis data stream to read.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisStreamsInput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// Kinesis data stream that is configured as the streaming source in the application
// input configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisStreamsInputDescription
type KinesisStreamsInputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Kinesis data stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access
	// the stream.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsInputDescription) String() string {
	return awsutil.Prettify(s)
}

// When you update the input configuration for an SQL-based Amazon Kinesis Data
// Analytics application, provides information about an Amazon Kinesis stream
// as the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisStreamsInputUpdate
type KinesisStreamsInputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the input Kinesis data stream to read.
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamsInputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsInputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisStreamsInputUpdate"}

	if s.ResourceARNUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When you configure an SQL-based Amazon Kinesis Data Analytics application's
// output, identifies a Kinesis data stream as the destination. You provide
// the stream Amazon Resource Name (ARN).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisStreamsOutput
type KinesisStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the destination Kinesis data stream to write to.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisStreamsOutput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application's output, describes
// the Kinesis data stream that is configured as its destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisStreamsOutputDescription
type KinesisStreamsOutputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Kinesis data stream.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to access
	// the stream.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s KinesisStreamsOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// When you update an SQL-based Amazon Kinesis Data Analytics application's
// output configuration using the UpdateApplication operation, provides information
// about a Kinesis data stream that is configured as the destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/KinesisStreamsOutputUpdate
type KinesisStreamsOutputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Kinesis data stream where you want
	// to write the output.
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s KinesisStreamsOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamsOutputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "KinesisStreamsOutputUpdate"}

	if s.ResourceARNUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When you configure an SQL-based Amazon Kinesis Data Analytics application's
// output, identifies an AWS Lambda function as the destination. You provide
// the function Amazon Resource Name (ARN) of the Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/LambdaOutput
type LambdaOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination Lambda function to write
	// to.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaOutput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaOutput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaOutput"}

	if s.ResourceARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application output, describes
// the AWS Lambda function that is configured as its destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/LambdaOutputDescription
type LambdaOutputDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination Lambda function.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to write to
	// the destination function.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s LambdaOutputDescription) String() string {
	return awsutil.Prettify(s)
}

// When you update an SQL-based Amazon Kinesis Data Analytics application's
// output configuration using the UpdateApplication operation, provides information
// about an AWS Lambda function that is configured as the destination.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/LambdaOutputUpdate
type LambdaOutputUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the destination AWS Lambda function.
	//
	// To specify an earlier version of the Lambda function than the latest, include
	// the Lambda function version in the Lambda function ARN. For more information
	// about Lambda ARNs, see Example ARNs: AWS Lambda (/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-lambda)
	//
	// ResourceARNUpdate is a required field
	ResourceARNUpdate *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LambdaOutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LambdaOutputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "LambdaOutputUpdate"}

	if s.ResourceARNUpdate == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceARNUpdate"))
	}
	if s.ResourceARNUpdate != nil && len(*s.ResourceARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceARNUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// When you configure an SQL-based Amazon Kinesis Data Analytics application's
// input at the time of creating or updating an application, provides additional
// mapping information specific to the record format (such as JSON, CSV, or
// record fields delimited by some delimiter) on the streaming source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/MappingParameters
type MappingParameters struct {
	_ struct{} `type:"structure"`

	// Provides additional mapping information when the record format uses delimiters
	// (for example, CSV).
	CSVMappingParameters *CSVMappingParameters `type:"structure"`

	// Provides additional mapping information when JSON is the record format on
	// the streaming source.
	JSONMappingParameters *JSONMappingParameters `type:"structure"`
}

// String returns the string representation
func (s MappingParameters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MappingParameters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MappingParameters"}
	if s.CSVMappingParameters != nil {
		if err := s.CSVMappingParameters.Validate(); err != nil {
			invalidParams.AddNested("CSVMappingParameters", err.(aws.ErrInvalidParams))
		}
	}
	if s.JSONMappingParameters != nil {
		if err := s.JSONMappingParameters.Validate(); err != nil {
			invalidParams.AddNested("JSONMappingParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes configuration parameters for Amazon CloudWatch logging for a Java-based
// Kinesis Data Analytics application. For more information about CloudWatch
// logging, see Monitoring (https://docs.aws.amazon.com/kinesisanalytics/latest/java/monitoring-overview.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/MonitoringConfiguration
type MonitoringConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes whether to use the default CloudWatch logging configuration for
	// an application.
	//
	// ConfigurationType is a required field
	ConfigurationType ConfigurationType `type:"string" required:"true" enum:"true"`

	// Describes the verbosity of the CloudWatch Logs for an application.
	LogLevel LogLevel `type:"string" enum:"true"`

	// Describes the granularity of the CloudWatch Logs for an application.
	MetricsLevel MetricsLevel `type:"string" enum:"true"`
}

// String returns the string representation
func (s MonitoringConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MonitoringConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "MonitoringConfiguration"}
	if len(s.ConfigurationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes configuration parameters for CloudWatch logging for a Java-based
// Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/MonitoringConfigurationDescription
type MonitoringConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes whether to use the default CloudWatch logging configuration for
	// an application.
	ConfigurationType ConfigurationType `type:"string" enum:"true"`

	// Describes the verbosity of the CloudWatch Logs for an application.
	LogLevel LogLevel `type:"string" enum:"true"`

	// Describes the granularity of the CloudWatch Logs for an application.
	MetricsLevel MetricsLevel `type:"string" enum:"true"`
}

// String returns the string representation
func (s MonitoringConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to configuration parameters for Amazon CloudWatch logging
// for a Java-based Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/MonitoringConfigurationUpdate
type MonitoringConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to whether to use the default CloudWatch logging configuration
	// for an application.
	ConfigurationTypeUpdate ConfigurationType `type:"string" enum:"true"`

	// Describes updates to the verbosity of the CloudWatch Logs for an application.
	LogLevelUpdate LogLevel `type:"string" enum:"true"`

	// Describes updates to the granularity of the CloudWatch Logs for an application.
	MetricsLevelUpdate MetricsLevel `type:"string" enum:"true"`
}

// String returns the string representation
func (s MonitoringConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Describes an SQL-based Amazon Kinesis Data Analytics application's output
// configuration, in which you identify an in-application stream and a destination
// where you want the in-application stream data to be written. The destination
// can be a Kinesis data stream or a Kinesis Data Firehose delivery stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/Output
type Output struct {
	_ struct{} `type:"structure"`

	// Describes the data format when records are written to the destination.
	//
	// DestinationSchema is a required field
	DestinationSchema *DestinationSchema `type:"structure" required:"true"`

	// Identifies an Amazon Kinesis Data Firehose delivery stream as the destination.
	KinesisFirehoseOutput *KinesisFirehoseOutput `type:"structure"`

	// Identifies an Amazon Kinesis data stream as the destination.
	KinesisStreamsOutput *KinesisStreamsOutput `type:"structure"`

	// Identifies an AWS Lambda function as the destination.
	LambdaOutput *LambdaOutput `type:"structure"`

	// The name of the in-application stream.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Output) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Output"}

	if s.DestinationSchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("DestinationSchema"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.DestinationSchema != nil {
		if err := s.DestinationSchema.Validate(); err != nil {
			invalidParams.AddNested("DestinationSchema", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseOutput != nil {
		if err := s.KinesisFirehoseOutput.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutput", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsOutput != nil {
		if err := s.KinesisStreamsOutput.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsOutput", err.(aws.ErrInvalidParams))
		}
	}
	if s.LambdaOutput != nil {
		if err := s.LambdaOutput.Validate(); err != nil {
			invalidParams.AddNested("LambdaOutput", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// application output configuration, which includes the in-application stream
// name and the destination where the stream data is written. The destination
// can be a Kinesis data stream or a Kinesis Data Firehose delivery stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/OutputDescription
type OutputDescription struct {
	_ struct{} `type:"structure"`

	// The data format used for writing data to the destination.
	DestinationSchema *DestinationSchema `type:"structure"`

	// Describes the Kinesis Data Firehose delivery stream that is configured as
	// the destination where output is written.
	KinesisFirehoseOutputDescription *KinesisFirehoseOutputDescription `type:"structure"`

	// Describes the Kinesis data stream that is configured as the destination where
	// output is written.
	KinesisStreamsOutputDescription *KinesisStreamsOutputDescription `type:"structure"`

	// Describes the Lambda function that is configured as the destination where
	// output is written.
	LambdaOutputDescription *LambdaOutputDescription `type:"structure"`

	// The name of the in-application stream that is configured as output.
	Name *string `min:"1" type:"string"`

	// A unique identifier for the output configuration.
	OutputId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s OutputDescription) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes updates
// to the output configuration identified by the OutputId.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/OutputUpdate
type OutputUpdate struct {
	_ struct{} `type:"structure"`

	// Describes the data format when records are written to the destination.
	DestinationSchemaUpdate *DestinationSchema `type:"structure"`

	// Describes a Kinesis Data Firehose delivery stream as the destination for
	// the output.
	KinesisFirehoseOutputUpdate *KinesisFirehoseOutputUpdate `type:"structure"`

	// Describes a Kinesis data stream as the destination for the output.
	KinesisStreamsOutputUpdate *KinesisStreamsOutputUpdate `type:"structure"`

	// Describes an AWS Lambda function as the destination for the output.
	LambdaOutputUpdate *LambdaOutputUpdate `type:"structure"`

	// If you want to specify a different in-application stream for this output
	// configuration, use this field to specify the new in-application stream name.
	NameUpdate *string `min:"1" type:"string"`

	// Identifies the specific output configuration that you want to update.
	//
	// OutputId is a required field
	OutputId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s OutputUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OutputUpdate"}
	if s.NameUpdate != nil && len(*s.NameUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NameUpdate", 1))
	}

	if s.OutputId == nil {
		invalidParams.Add(aws.NewErrParamRequired("OutputId"))
	}
	if s.OutputId != nil && len(*s.OutputId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("OutputId", 1))
	}
	if s.DestinationSchemaUpdate != nil {
		if err := s.DestinationSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("DestinationSchemaUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisFirehoseOutputUpdate != nil {
		if err := s.KinesisFirehoseOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisFirehoseOutputUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.KinesisStreamsOutputUpdate != nil {
		if err := s.KinesisStreamsOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamsOutputUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.LambdaOutputUpdate != nil {
		if err := s.LambdaOutputUpdate.Validate(); err != nil {
			invalidParams.AddNested("LambdaOutputUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes parameters for how a Java-based Amazon Kinesis Data Analytics application
// executes multiple tasks simultaneously. For more information about parallelism,
// see Parallel Execution (https://ci.apache.org/projects/flink/flink-docs-stable/dev/parallel.html)
// in the Apache Flink Documentation (https://ci.apache.org/projects/flink/flink-docs-release-1.6/).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ParallelismConfiguration
type ParallelismConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes whether the Kinesis Data Analytics service can increase the parallelism
	// of the application in response to increased throughput.
	AutoScalingEnabled *bool `type:"boolean"`

	// Describes whether the application uses the default parallelism for the Kinesis
	// Data Analytics service.
	//
	// ConfigurationType is a required field
	ConfigurationType ConfigurationType `type:"string" required:"true" enum:"true"`

	// Describes the initial number of parallel tasks that a Java-based Kinesis
	// Data Analytics application can perform. The Kinesis Data Analytics service
	// can increase this number automatically if ParallelismConfiguration$AutoScalingEnabled
	// is set to true.
	Parallelism *int64 `min:"1" type:"integer"`

	// Describes the number of parallel tasks that a Java-based Kinesis Data Analytics
	// application can perform per Kinesis Processing Unit (KPU) used by the application.
	// For more information about KPUs, see Amazon Kinesis Data Analytics Pricing
	// (http://aws.amazon.com/kinesis/data-analytics/pricing/).
	ParallelismPerKPU *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ParallelismConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParallelismConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParallelismConfiguration"}
	if len(s.ConfigurationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ConfigurationType"))
	}
	if s.Parallelism != nil && *s.Parallelism < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Parallelism", 1))
	}
	if s.ParallelismPerKPU != nil && *s.ParallelismPerKPU < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ParallelismPerKPU", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes parameters for how a Java-based Kinesis Data Analytics application
// executes multiple tasks simultaneously.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ParallelismConfigurationDescription
type ParallelismConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes whether the Kinesis Data Analytics service can increase the parallelism
	// of the application in response to increased throughput.
	AutoScalingEnabled *bool `type:"boolean"`

	// Describes whether the application uses the default parallelism for the Kinesis
	// Data Analytics service.
	ConfigurationType ConfigurationType `type:"string" enum:"true"`

	// Describes the current number of parallel tasks that a Java-based Kinesis
	// Data Analytics application can perform.
	CurrentParallelism *int64 `min:"1" type:"integer"`

	// Describes the initial number of parallel tasks that a Java-based Kinesis
	// Data Analytics application can perform.
	Parallelism *int64 `min:"1" type:"integer"`

	// Describes the number of parallel tasks that a Java-based Kinesis Data Analytics
	// application can perform per Kinesis Processing Unit (KPU) used by the application.
	ParallelismPerKPU *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ParallelismConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to parameters for how a Java-based Kinesis Data Analytics
// application executes multiple tasks simultaneously.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ParallelismConfigurationUpdate
type ParallelismConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to whether the Kinesis Data Analytics service can increase
	// the parallelism of the application in response to increased throughput.
	AutoScalingEnabledUpdate *bool `type:"boolean"`

	// Describes updates to whether the application uses the default parallelism
	// for the Kinesis Data Analytics service, or if a custom parallelism is used.
	ConfigurationTypeUpdate ConfigurationType `type:"string" enum:"true"`

	// Describes updates to the number of parallel tasks an application can perform
	// per Kinesis Processing Unit (KPU) used by the application.
	ParallelismPerKPUUpdate *int64 `min:"1" type:"integer"`

	// Describes updates to the initial number of parallel tasks an application
	// can perform.
	ParallelismUpdate *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s ParallelismConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParallelismConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ParallelismConfigurationUpdate"}
	if s.ParallelismPerKPUUpdate != nil && *s.ParallelismPerKPUUpdate < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ParallelismPerKPUUpdate", 1))
	}
	if s.ParallelismUpdate != nil && *s.ParallelismUpdate < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ParallelismUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Property key-value pairs passed into a Java-based Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/PropertyGroup
type PropertyGroup struct {
	_ struct{} `type:"structure"`

	// Describes the key of an application execution property key-value pair.
	//
	// PropertyGroupId is a required field
	PropertyGroupId *string `min:"1" type:"string" required:"true"`

	// Describes the value of an application execution property key-value pair.
	//
	// PropertyMap is a required field
	PropertyMap map[string]string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s PropertyGroup) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PropertyGroup) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PropertyGroup"}

	if s.PropertyGroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyGroupId"))
	}
	if s.PropertyGroupId != nil && len(*s.PropertyGroupId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyGroupId", 1))
	}

	if s.PropertyMap == nil {
		invalidParams.Add(aws.NewErrParamRequired("PropertyMap"))
	}
	if s.PropertyMap != nil && len(s.PropertyMap) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PropertyMap", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// mapping of each data element in the streaming source to the corresponding
// column in the in-application stream.
//
// Also used to describe the format of the reference data source.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RecordColumn
type RecordColumn struct {
	_ struct{} `type:"structure"`

	// A reference to the data element in the streaming input or the reference data
	// source.
	Mapping *string `type:"string"`

	// The name of the column that is created in the in-application input stream
	// or reference table.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The type of column created in the in-application input stream or reference
	// table.
	//
	// SqlType is a required field
	SqlType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RecordColumn) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordColumn) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecordColumn"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.SqlType == nil {
		invalidParams.Add(aws.NewErrParamRequired("SqlType"))
	}
	if s.SqlType != nil && len(*s.SqlType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SqlType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// record format and relevant mapping information that should be applied to
// schematize the records on the stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RecordFormat
type RecordFormat struct {
	_ struct{} `type:"structure"`

	// When you configure application input at the time of creating or updating
	// an application, provides additional mapping information specific to the record
	// format (such as JSON, CSV, or record fields delimited by some delimiter)
	// on the streaming source.
	MappingParameters *MappingParameters `type:"structure"`

	// The type of record format.
	//
	// RecordFormatType is a required field
	RecordFormatType RecordFormatType `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s RecordFormat) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecordFormat) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RecordFormat"}
	if len(s.RecordFormatType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("RecordFormatType"))
	}
	if s.MappingParameters != nil {
		if err := s.MappingParameters.Validate(); err != nil {
			invalidParams.AddNested("MappingParameters", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// reference data source by providing the source information (Amazon S3 bucket
// name and object key name), the resulting in-application table name that is
// created, and the necessary schema to map the data elements in the Amazon
// S3 object to the in-application table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ReferenceDataSource
type ReferenceDataSource struct {
	_ struct{} `type:"structure"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	//
	// ReferenceSchema is a required field
	ReferenceSchema *SourceSchema `type:"structure" required:"true"`

	// Identifies the S3 bucket and object that contains the reference data. A Kinesis
	// Data Analytics application loads reference data only once. If the data changes,
	// you call the UpdateApplication operation to trigger reloading of data into
	// your application.
	S3ReferenceDataSource *S3ReferenceDataSource `type:"structure"`

	// The name of the in-application table to create.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ReferenceDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReferenceDataSource"}

	if s.ReferenceSchema == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReferenceSchema"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}
	if s.ReferenceSchema != nil {
		if err := s.ReferenceSchema.Validate(); err != nil {
			invalidParams.AddNested("ReferenceSchema", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3ReferenceDataSource != nil {
		if err := s.S3ReferenceDataSource.Validate(); err != nil {
			invalidParams.AddNested("S3ReferenceDataSource", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// reference data source configured for an application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ReferenceDataSourceDescription
type ReferenceDataSourceDescription struct {
	_ struct{} `type:"structure"`

	// The ID of the reference data source. This is the ID that Kinesis Data Analytics
	// assigns when you add the reference data source to your application using
	// the CreateApplication or UpdateApplication operation.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchema *SourceSchema `type:"structure"`

	// Provides the Amazon S3 bucket name, the object key name that contains the
	// reference data.
	//
	// S3ReferenceDataSourceDescription is a required field
	S3ReferenceDataSourceDescription *S3ReferenceDataSourceDescription `type:"structure" required:"true"`

	// The in-application table name created by the specific reference data source
	// configuration.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ReferenceDataSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// When you update a reference data source configuration for a SQL-based Amazon
// Kinesis Data Analytics application, this object provides all the updated
// values (such as the source bucket name and object key name), the in-application
// table name that is created, and updated mapping information that maps the
// data in the Amazon S3 object to the in-application reference table that is
// created.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/ReferenceDataSourceUpdate
type ReferenceDataSourceUpdate struct {
	_ struct{} `type:"structure"`

	// The ID of the reference data source that is being updated. You can use the
	// DescribeApplication operation to get this value.
	//
	// ReferenceId is a required field
	ReferenceId *string `min:"1" type:"string" required:"true"`

	// Describes the format of the data in the streaming source, and how each data
	// element maps to corresponding columns created in the in-application stream.
	ReferenceSchemaUpdate *SourceSchema `type:"structure"`

	// Describes the S3 bucket name, object key name, and IAM role that Kinesis
	// Data Analytics can assume to read the Amazon S3 object on your behalf and
	// populate the in-application reference table.
	S3ReferenceDataSourceUpdate *S3ReferenceDataSourceUpdate `type:"structure"`

	// The in-application table name that is created by this update.
	TableNameUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ReferenceDataSourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReferenceDataSourceUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ReferenceDataSourceUpdate"}

	if s.ReferenceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ReferenceId"))
	}
	if s.ReferenceId != nil && len(*s.ReferenceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ReferenceId", 1))
	}
	if s.TableNameUpdate != nil && len(*s.TableNameUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableNameUpdate", 1))
	}
	if s.ReferenceSchemaUpdate != nil {
		if err := s.ReferenceSchemaUpdate.Validate(); err != nil {
			invalidParams.AddNested("ReferenceSchemaUpdate", err.(aws.ErrInvalidParams))
		}
	}
	if s.S3ReferenceDataSourceUpdate != nil {
		if err := s.S3ReferenceDataSourceUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3ReferenceDataSourceUpdate", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the starting parameters for an Amazon Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RunConfiguration
type RunConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes the restore behavior of a restarting application.
	ApplicationRestoreConfiguration *ApplicationRestoreConfiguration `type:"structure"`

	// Describes the starting parameters for an SQL-based Kinesis Data Analytics
	// application.
	SqlRunConfigurations []SqlRunConfiguration `type:"list"`
}

// String returns the string representation
func (s RunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RunConfiguration"}
	if s.ApplicationRestoreConfiguration != nil {
		if err := s.ApplicationRestoreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationRestoreConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.SqlRunConfigurations != nil {
		for i, v := range s.SqlRunConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SqlRunConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the starting properties for a Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RunConfigurationDescription
type RunConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// Describes the restore behavior of a restarting application.
	ApplicationRestoreConfigurationDescription *ApplicationRestoreConfiguration `type:"structure"`
}

// String returns the string representation
func (s RunConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes the updates to the starting parameters for a Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/RunConfigurationUpdate
type RunConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes updates to the restore behavior of a restarting application.
	ApplicationRestoreConfiguration *ApplicationRestoreConfiguration `type:"structure"`
}

// String returns the string representation
func (s RunConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RunConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RunConfigurationUpdate"}
	if s.ApplicationRestoreConfiguration != nil {
		if err := s.ApplicationRestoreConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ApplicationRestoreConfiguration", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the location of a Java-based Amazon Kinesis Data Analytics application's
// code stored in an S3 bucket.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/S3ApplicationCodeLocationDescription
type S3ApplicationCodeLocationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The file key for the object containing the application code.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// The version of the object containing the application code.
	ObjectVersion *string `type:"string"`
}

// String returns the string representation
func (s S3ApplicationCodeLocationDescription) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, provides a description
// of an Amazon S3 data source, including the Amazon Resource Name (ARN) of
// the S3 bucket and the name of the Amazon S3 object that contains the data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/S3Configuration
type S3Configuration struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket that contains the data.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The name of the object that contains the data.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Configuration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Configuration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Configuration"}

	if s.BucketARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketARN", 1))
	}

	if s.FileKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileKey"))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For a Java-based Amazon Kinesis Data Analytics application, provides a description
// of an Amazon S3 object, including the Amazon Resource Name (ARN) of the S3
// bucket, the name of the Amazon S3 object that contains the data, and the
// version number of the Amazon S3 object that contains the data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/S3ContentLocation
type S3ContentLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The file key for the object containing the application code.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// The version of the object containing the application code.
	ObjectVersion *string `type:"string"`
}

// String returns the string representation
func (s S3ContentLocation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ContentLocation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ContentLocation"}

	if s.BucketARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketARN", 1))
	}

	if s.FileKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("FileKey"))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes an update for the Amazon S3 code content location for a Java-based
// Amazon Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/S3ContentLocationUpdate
type S3ContentLocationUpdate struct {
	_ struct{} `type:"structure"`

	// The new Amazon Resource Name (ARN) for the S3 bucket containing the application
	// code.
	BucketARNUpdate *string `min:"1" type:"string"`

	// The new file key for the object containing the application code.
	FileKeyUpdate *string `min:"1" type:"string"`

	// The new version of the object containing the application code.
	ObjectVersionUpdate *string `type:"string"`
}

// String returns the string representation
func (s S3ContentLocationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ContentLocationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ContentLocationUpdate"}
	if s.BucketARNUpdate != nil && len(*s.BucketARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketARNUpdate", 1))
	}
	if s.FileKeyUpdate != nil && len(*s.FileKeyUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileKeyUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, identifies the
// Amazon S3 bucket and object that contains the reference data.
//
// A Kinesis Data Analytics application loads reference data only once. If the
// data changes, you call the UpdateApplication operation to trigger reloading
// of data into your application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/S3ReferenceDataSource
type S3ReferenceDataSource struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	BucketARN *string `min:"1" type:"string"`

	// The object key name containing the reference data.
	FileKey *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3ReferenceDataSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReferenceDataSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ReferenceDataSource"}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketARN", 1))
	}
	if s.FileKey != nil && len(*s.FileKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// For an SQL-based Amazon Kinesis Data Analytics application, provides the
// bucket name and object key name that stores the reference data.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/S3ReferenceDataSourceDescription
type S3ReferenceDataSourceDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// Amazon S3 object key name.
	//
	// FileKey is a required field
	FileKey *string `min:"1" type:"string" required:"true"`

	// The ARN of the IAM role that Kinesis Data Analytics can assume to read the
	// Amazon S3 object on your behalf to populate the in-application reference
	// table.
	//
	// Provided for backward compatibility. Applications that are created with the
	// current API version have an application-level service execution role rather
	// than a resource-level role.
	ReferenceRoleARN *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3ReferenceDataSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// Amazon S3 bucket name and object key name for an in-application reference
// table.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/S3ReferenceDataSourceUpdate
type S3ReferenceDataSourceUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the S3 bucket.
	BucketARNUpdate *string `min:"1" type:"string"`

	// The object key name.
	FileKeyUpdate *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3ReferenceDataSourceUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3ReferenceDataSourceUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3ReferenceDataSourceUpdate"}
	if s.BucketARNUpdate != nil && len(*s.BucketARNUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("BucketARNUpdate", 1))
	}
	if s.FileKeyUpdate != nil && len(*s.FileKeyUpdate) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("FileKeyUpdate", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides details about a snapshot of application state.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/SnapshotDetails
type SnapshotDetails struct {
	_ struct{} `type:"structure"`

	// The current application version ID when the snapshot was created.
	//
	// ApplicationVersionId is a required field
	ApplicationVersionId *int64 `min:"1" type:"long" required:"true"`

	// The timestamp of the application snapshot.
	SnapshotCreationTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The identifier for the application snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `min:"1" type:"string" required:"true"`

	// The status of the application snapshot.
	//
	// SnapshotStatus is a required field
	SnapshotStatus SnapshotStatus `type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s SnapshotDetails) String() string {
	return awsutil.Prettify(s)
}

// For an SQL-based Amazon Kinesis Data Analytics application, describes the
// format of the data in the streaming source, and how each data element maps
// to corresponding columns created in the in-application stream.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/SourceSchema
type SourceSchema struct {
	_ struct{} `type:"structure"`

	// A list of RecordColumn objects.
	//
	// RecordColumns is a required field
	RecordColumns []RecordColumn `min:"1" type:"list" required:"true"`

	// Specifies the encoding of the records in the streaming source. For example,
	// UTF-8.
	RecordEncoding *string `type:"string"`

	// Specifies the format of the records on the streaming source.
	//
	// RecordFormat is a required field
	RecordFormat *RecordFormat `type:"structure" required:"true"`
}

// String returns the string representation
func (s SourceSchema) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceSchema) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SourceSchema"}

	if s.RecordColumns == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordColumns"))
	}
	if s.RecordColumns != nil && len(s.RecordColumns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RecordColumns", 1))
	}

	if s.RecordFormat == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecordFormat"))
	}
	if s.RecordColumns != nil {
		for i, v := range s.RecordColumns {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RecordColumns", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.RecordFormat != nil {
		if err := s.RecordFormat.Validate(); err != nil {
			invalidParams.AddNested("RecordFormat", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the inputs, outputs, and reference data sources for an SQL-based
// Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/SqlApplicationConfiguration
type SqlApplicationConfiguration struct {
	_ struct{} `type:"structure"`

	// The array of Input objects describing the input streams used by the application.
	Inputs []Input `type:"list"`

	// The array of Output objects describing the destination streams used by the
	// application.
	Outputs []Output `type:"list"`

	// The array of ReferenceDataSource objects describing the reference data sources
	// used by the application.
	ReferenceDataSources []ReferenceDataSource `type:"list"`
}

// String returns the string representation
func (s SqlApplicationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlApplicationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SqlApplicationConfiguration"}
	if s.Inputs != nil {
		for i, v := range s.Inputs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Inputs", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Outputs != nil {
		for i, v := range s.Outputs {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Outputs", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ReferenceDataSources != nil {
		for i, v := range s.ReferenceDataSources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceDataSources", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the inputs, outputs, and reference data sources for an SQL-based
// Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/SqlApplicationConfigurationDescription
type SqlApplicationConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The array of InputDescription objects describing the input streams used by
	// the application.
	InputDescriptions []InputDescription `type:"list"`

	// The array of OutputDescription objects describing the destination streams
	// used by the application.
	OutputDescriptions []OutputDescription `type:"list"`

	// The array of ReferenceDataSourceDescription objects describing the reference
	// data sources used by the application.
	ReferenceDataSourceDescriptions []ReferenceDataSourceDescription `type:"list"`
}

// String returns the string representation
func (s SqlApplicationConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// Describes updates to the input streams, destination streams, and reference
// data sources for an SQL-based Kinesis Data Analytics application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/SqlApplicationConfigurationUpdate
type SqlApplicationConfigurationUpdate struct {
	_ struct{} `type:"structure"`

	// The array of InputUpdate objects describing the new input streams used by
	// the application.
	InputUpdates []InputUpdate `type:"list"`

	// The array of OutputUpdate objects describing the new destination streams
	// used by the application.
	OutputUpdates []OutputUpdate `type:"list"`

	// The array of ReferenceDataSourceUpdate objects describing the new reference
	// data sources used by the application.
	ReferenceDataSourceUpdates []ReferenceDataSourceUpdate `type:"list"`
}

// String returns the string representation
func (s SqlApplicationConfigurationUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlApplicationConfigurationUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SqlApplicationConfigurationUpdate"}
	if s.InputUpdates != nil {
		for i, v := range s.InputUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.OutputUpdates != nil {
		for i, v := range s.OutputUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OutputUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.ReferenceDataSourceUpdates != nil {
		for i, v := range s.ReferenceDataSourceUpdates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ReferenceDataSourceUpdates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the starting parameters for an SQL-based Kinesis Data Analytics
// application.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/SqlRunConfiguration
type SqlRunConfiguration struct {
	_ struct{} `type:"structure"`

	// The input source ID. You can get this ID by calling the DescribeApplication
	// operation.
	//
	// InputId is a required field
	InputId *string `min:"1" type:"string" required:"true"`

	// The point at which you want the application to start processing records from
	// the streaming source.
	//
	// InputStartingPositionConfiguration is a required field
	InputStartingPositionConfiguration *InputStartingPositionConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s SqlRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlRunConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SqlRunConfiguration"}

	if s.InputId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputId"))
	}
	if s.InputId != nil && len(*s.InputId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputId", 1))
	}

	if s.InputStartingPositionConfiguration == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputStartingPositionConfiguration"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// A key-value pair (the value is optional) that you can define and assign to
// AWS resources. If you specify a tag that already exists, the tag value is
// replaced with the value that you specify in the request. Note that the maximum
// number of application tags includes system tags. The maximum number of user-defined
// application tags is 50. For more information, see Using Cost Allocation Tags
// (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the AWS Billing and Cost Management Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the key-value tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the key-value tag. The value is optional.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
