// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotanalytics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelinesRequest
type ListPipelinesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in this request.
	//
	// The default value is 100.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipelinesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPipelinesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPipelinesInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelinesResponse
type ListPipelinesOutput struct {
	_ struct{} `type:"structure"`

	// The token to retrieve the next set of results, or null if there are no more
	// results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of "PipelineSummary" objects.
	PipelineSummaries []PipelineSummary `locationName:"pipelineSummaries" type:"list"`
}

// String returns the string representation
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPipelinesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PipelineSummaries) > 0 {
		v := s.PipelineSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "pipelineSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest returns a request value for making API operation for
// AWS IoT Analytics.
//
// Retrieves a list of pipelines.
//
//    // Example sending a request using ListPipelinesRequest.
//    req := client.ListPipelinesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iotanalytics-2017-11-27/ListPipelines
func (c *Client) ListPipelinesRequest(input *ListPipelinesInput) ListPipelinesRequest {
	op := &aws.Operation{
		Name:       opListPipelines,
		HTTPMethod: "GET",
		HTTPPath:   "/pipelines",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	req := c.newRequest(op, input, &ListPipelinesOutput{})
	return ListPipelinesRequest{Request: req, Input: input, Copy: c.ListPipelinesRequest}
}

// ListPipelinesRequest is the request type for the
// ListPipelines API operation.
type ListPipelinesRequest struct {
	*aws.Request
	Input *ListPipelinesInput
	Copy  func(*ListPipelinesInput) ListPipelinesRequest
}

// Send marshals and sends the ListPipelines API request.
func (r ListPipelinesRequest) Send(ctx context.Context) (*ListPipelinesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPipelinesResponse{
		ListPipelinesOutput: r.Request.Data.(*ListPipelinesOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPipelinesRequestPaginator returns a paginator for ListPipelines.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPipelinesRequest(input)
//   p := iotanalytics.NewListPipelinesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPipelinesPaginator(req ListPipelinesRequest) ListPipelinesPaginator {
	return ListPipelinesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPipelinesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPipelinesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPipelinesPaginator struct {
	aws.Pager
}

func (p *ListPipelinesPaginator) CurrentPage() *ListPipelinesOutput {
	return p.Pager.CurrentPage().(*ListPipelinesOutput)
}

// ListPipelinesResponse is the response type for the
// ListPipelines API operation.
type ListPipelinesResponse struct {
	*ListPipelinesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPipelines request.
func (r *ListPipelinesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
