// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot1clickdevicesservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethodRequest
type InvokeDeviceMethodInput struct {
	_ struct{} `type:"structure"`

	// DeviceId is a required field
	DeviceId *string `location:"uri" locationName:"deviceId" type:"string" required:"true"`

	// The device method to invoke.
	DeviceMethod *DeviceMethod `locationName:"deviceMethod" type:"structure"`

	// A JSON encoded string containing the device method request parameters.
	DeviceMethodParameters *string `locationName:"deviceMethodParameters" type:"string"`
}

// String returns the string representation
func (s InvokeDeviceMethodInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InvokeDeviceMethodInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InvokeDeviceMethodInput"}

	if s.DeviceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeviceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvokeDeviceMethodInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DeviceMethod != nil {
		v := s.DeviceMethod

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "deviceMethod", v, metadata)
	}
	if s.DeviceMethodParameters != nil {
		v := *s.DeviceMethodParameters

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deviceMethodParameters", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceId != nil {
		v := *s.DeviceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "deviceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethodResponse
type InvokeDeviceMethodOutput struct {
	_ struct{} `type:"structure"`

	// A JSON encoded string containing the device method response.
	DeviceMethodResponse *string `locationName:"deviceMethodResponse" type:"string"`
}

// String returns the string representation
func (s InvokeDeviceMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InvokeDeviceMethodOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.DeviceMethodResponse != nil {
		v := *s.DeviceMethodResponse

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "deviceMethodResponse", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opInvokeDeviceMethod = "InvokeDeviceMethod"

// InvokeDeviceMethodRequest returns a request value for making API operation for
// AWS IoT 1-Click Devices Service.
//
// Given a device ID, issues a request to invoke a named device method (with
// possible parameters). See the "Example POST" code snippet below.
//
//    // Example sending a request using InvokeDeviceMethodRequest.
//    req := client.InvokeDeviceMethodRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devices-2018-05-14/InvokeDeviceMethod
func (c *Client) InvokeDeviceMethodRequest(input *InvokeDeviceMethodInput) InvokeDeviceMethodRequest {
	op := &aws.Operation{
		Name:       opInvokeDeviceMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/devices/{deviceId}/methods",
	}

	if input == nil {
		input = &InvokeDeviceMethodInput{}
	}

	req := c.newRequest(op, input, &InvokeDeviceMethodOutput{})
	return InvokeDeviceMethodRequest{Request: req, Input: input, Copy: c.InvokeDeviceMethodRequest}
}

// InvokeDeviceMethodRequest is the request type for the
// InvokeDeviceMethod API operation.
type InvokeDeviceMethodRequest struct {
	*aws.Request
	Input *InvokeDeviceMethodInput
	Copy  func(*InvokeDeviceMethodInput) InvokeDeviceMethodRequest
}

// Send marshals and sends the InvokeDeviceMethod API request.
func (r InvokeDeviceMethodRequest) Send(ctx context.Context) (*InvokeDeviceMethodResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InvokeDeviceMethodResponse{
		InvokeDeviceMethodOutput: r.Request.Data.(*InvokeDeviceMethodOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InvokeDeviceMethodResponse is the response type for the
// InvokeDeviceMethod API operation.
type InvokeDeviceMethodResponse struct {
	*InvokeDeviceMethodOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InvokeDeviceMethod request.
func (r *InvokeDeviceMethodResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
